<?php

class popularProducts extends WP_Widget {

   /** constructor */
   function popularProducts() {
      parent::WP_Widget(false, __( 'Most Popular Products', 'imwb_zonpress' ), array('description' => __( 'Use this widget to show the most popular products by CTR %', 'imwb_zonpress' )));	
   }
   
   /** @see WP_Widget::widget */
   function widget($args, $instance) {	

      extract( $args );
      $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
      $no_entries = $instance['no_entries'];

      echo $before_widget;
      if ( $title )
         echo $before_title . $title . $after_title; 
         
      if(!$no_entries)
         $no_entries = 6;
   			
      $args = array( 'showposts' => $no_entries, 'orderby' => 'meta_value_num','meta_key' => '_imwb_zonpress_post_ctr', 'order' => 'DESC' );
      $query = new WP_Query( $args );

      if ($query->have_posts()) : ?>
        <ul>
      
      <?php while ($query->have_posts()) : $query->the_post();
?>
         <li class="thumb">
              <a href="<?php echo get_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php echo imwb_zonpress_get_post_link_target();?>>
           <?php imwb_zonpress_the_post_thumbnail(get_the_ID(), '153', '128');?> 
           </a>
         </li>
      <?php endwhile; ?>
      </ul>
      
<?php      endif; 
      
      // Reset Post Data
      wp_reset_postdata();
      
      echo $after_widget;
  
   }
   
   /** @see WP_Widget::update */
   function update($new_instance, $old_instance) {				
      $instance = $old_instance;
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['no_entries'] = strip_tags($new_instance['no_entries']);    
      return $instance;
   }
   
   /** @see WP_Widget::form */
   function form($instance) {				
      $title = esc_attr($instance['title']);
      $no_entries = esc_attr($instance['no_entries']);
     ?>
     <p><label for="<?php echo $this->get_field_id('title'); ?>">
     <?php _e('Title:'); ?> 
     <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
    
     <p><label for="<?php echo $this->get_field_id('no_entries'); ?>">
     <?php _e('No of entries to show:'); ?> 
     <input id="<?php echo $this->get_field_id('no_entries'); ?>" name="<?php echo $this->get_field_name('no_entries'); ?>" type="text" value="<?php echo $no_entries; ?>" size="5" /></label></p>
            
   <?php 
   }

}

register_widget('popularProducts');

class newestProducts extends WP_Widget {

   /** constructor */
   function newestProducts() {
      parent::WP_Widget(false, __( 'Newest Products', 'imwb_zonpress' ), array('description' => __( 'Use this widget to show the newest products', 'imwb_zonpress' )));	
   }
   
   /** @see WP_Widget::widget */
   function widget($args, $instance) {		
      extract( $args );
      $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
      $no_entries = $instance['no_entries'];

      echo $before_widget;
      if ( $title )
         echo $before_title . $title . $after_title; 
         
      if(!$no_entries)
         $no_entries = 6;
   			
      $args = array( 'showposts' => $no_entries, 'orderby' => 'date', 'order' => 'DESC' );
      $query = new WP_Query( $args );

      if ($query->have_posts()) : ?>
        <ul>
      
      <?php while ($query->have_posts()) : $query->the_post();
?>
         <li class="thumb">
              <a href="<?php echo get_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php echo imwb_zonpress_get_post_link_target();?>>
           <?php imwb_zonpress_the_post_thumbnail(get_the_ID(), '153', '128');?> 
           </a>
         </li>
      <?php endwhile; ?>
      </ul>
      
<?php      endif; 
      
      // Reset Post Data
      wp_reset_postdata();
      
      echo $after_widget;
  
   }
   
   /** @see WP_Widget::update */
   function update($new_instance, $old_instance) {				
      $instance = $old_instance;
      $instance['title'] = strip_tags($new_instance['title']);
      $instance['no_entries'] = strip_tags($new_instance['no_entries']);    
      return $instance;
   }
   
   /** @see WP_Widget::form */
   function form($instance) {				
      $title = esc_attr($instance['title']);
      $no_entries = esc_attr($instance['no_entries']);
     ?>
     <p><label for="<?php echo $this->get_field_id('title'); ?>">
     <?php _e('Title:'); ?> 
     <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
    
     <p><label for="<?php echo $this->get_field_id('no_entries'); ?>">
     <?php _e('No of entries to show:'); ?> 
     <input id="<?php echo $this->get_field_id('no_entries'); ?>" name="<?php echo $this->get_field_name('no_entries'); ?>" type="text" value="<?php echo $no_entries; ?>" size="5" /></label></p>
            
   <?php 
   }

}

register_widget('newestProducts');
?>