<?php
add_action( 'admin_init', 'imwb_zonpress_theme_options_init' );
add_action( 'admin_menu', 'imwb_zonpress_theme_options_add_page' );

require_once ( get_template_directory() . '/getresponse-api/jsonRPCClient.php' );
require_once ( get_template_directory() . '/aweber_api/aweber_api.php');
require_once ( get_template_directory() . '/HtmlFormParser.php');

/**
 * Init plugin options to white list our options
 */
function imwb_zonpress_theme_options_init(){
	register_setting( 'imwb_zonpress_options', 'imwb_zonpress_theme_options', 'imwb_zonpress_theme_options_validate' );
	wp_register_style( 'imwb_zonpress-theme-options-stylesheet', get_template_directory_uri().'/css/admin_options_page.css' );
	wp_register_script( 'imwb_zonpress-theme-options-script', get_template_directory_uri().'/js/admin_options.js' );
}

/**
 * Load up the menu page
 */
function imwb_zonpress_theme_options_add_page() {

	$page = add_theme_page( __( 'Theme Options', 'imwb_zonpress' ), __( 'Theme Options', 'imwb_zonpress' ), 'edit_theme_options', 'imwb_zonpress_theme_options', 'imwb_zonpress_theme_options_do_page' );

	/* Using registered $page handle to hook stylesheet loading */
   add_action( 'admin_print_styles-' . $page, 'imwb_zonpress_admin_styles' );
   add_action( 'admin_print_scripts-' . $page, 'imwb_zonpress_admin_scripts' );

   $page = add_users_page(__( 'Export Leads', 'imwb_zonpress' ), __( 'Export Leads', 'imwb_zonpress' ), 'list_users', 'imwb_zonpress_theme_export_users', 'imwb_zonpress_theme_export_do_page' );
   add_action( 'admin_print_styles-' . $page, 'imwb_zonpress_admin_styles' );

}

function imwb_zonpress_admin_styles() {
   wp_enqueue_style( 'farbtastic' );
   wp_enqueue_style('imwb_zonpress-theme-options-stylesheet');
}

function imwb_zonpress_admin_scripts() {
   wp_enqueue_script( 'farbtastic' );
   wp_enqueue_script('imwb_zonpress-theme-options-script');
}

/**
 * Returns the default options for Twenty Eleven.
 *
 */
function imwb_zonpress_get_default_theme_options() {
	$default_theme_options = array(
	   'faviconurl' => '',
	   'defOGPImg' => '',
	   'headerbgcol' => '#FFFFFF',
	   'sitemenutxtcol' => '#606060',
	   'headerscripts' => '',
	   'hidemenu' => 'N',
	   'menubgcol' => '#FFFFFF',
  	   'menutxtcol' => '#606060',
  	   'menuseltxtcol' => '#000000',
	   'homepagemenu' => 'N',
	   'mrsmenu' => 'N',
	   'mrsmenutxt' => 'What\'s New',
	   'mrsmenutitle' => 'See What\'s New',
	   'includecats' => '',
	   'othercatmenu' => 'N',
	   'othercatmenutxt' => 'More',
	   'excludecats' => '',
	   'posthidemenu' => 'N',
	   'postmenubgcol' => '#FFFFFF',
	   'postmenutxtcol' => '#606060',
	   'postmenuseltxtcol' => '#0088CC',
	   'postmrsmenu' => 'N',
	   'postmrsmenutxt' => 'Newest',
      'posttrsmenu' => 'N',
      'posttrsmenutxt' => 'Popular',
      'posthpsmenu' => 'N',
      'posthpsmenutxt' => 'Highest Price',
      'postlpsmenu' => 'N',
      'postlpsmenutxt' => 'Lowest Price',
	   'hidesearch' => 'N',
	   'searchtext' => 'Find Stuff...',
  	   'hidefooter' => 'N',
  	   'hidesocialbtns' => 'N',
  	   'twitteruser' => '',
  	   'facebookuser' => '',
  	   'googleuser' => '',
  	   'pinterestuser' => '',
  	   'reddituser' => '',
  	   'rssfeedurl' => get_bloginfo('rss2_url'),
  	   'hiderotator' => 'N',
  	   'fplistorder' => '0',
  	   'postsperrotator' => '10',
  	   'delayrotator' => 5,
  	   'fpexcludecats' => '',
  	   'fpbgcol' => '#ffffff',
  	   'fpbdrcol' => '#ffffff',
  	   'fptitlecol' => '#0088CC',
  	   'fptitlehvrcol' => '#005580',
  	   'fppricecol' => '#347C17',
  	   'fpdesccol' => '#606060',
  	   'fphideprice' => 'N',
	   'listorder' => '0',
	   'hpexcludecats' => '',
 	   'linknewwin' => '1',
		'sidebarbgcol' => '#ffffff',
		'widgettitlebgcol' => '#C6C6C6',
		'widgettitletxtcol' => '#040404',
		'showtitle' => '1',
		'postcontent' => 'E',
		'postchars' => '100',
		'postmoretext' => '[More]',
		'shareoptions' => 'F,T,P',
		'postbgcol' => '#ffffff',
		'posttitlecol' => '#606060',
		'posttitlehvrcol' => '#005580',
   	'postdesccol' => '#606060',
   	'postprdbtntxt' => 'Check It Out!',
   	'postprdbtntxtcol' => '#FFFFFF',
   	'postprdbtnbgcol' => '#5BB75B',
   	'postprdbtnbghvrcol' => '#51A351',
   	'hideptthumbs' => 'N',
   	'ptthumbsshown' => '6',
   	'ptprdbtntxt' => 'Buy Now!',
		'hidepttitle' => 'N',
		'hideptprice' => 'N',
		'hideptdetails' => 'N',
		'commenttype' => '0',
		'fbappid' => '',
		'hideptlikestats' => 'N',
		'hideptcommenttime' => 'N',
		'pagesidebar' => '0',
		'postsidebar' => '2',
		'catsidebar' => '2',
		'hidecatprice' => 'N',
		'hidecatdesc' => 'N',
		'postspercat' => '12',
		'hidepgtitle' => 'N',
		'hidepgcomments' => 'N',
		'footerbgcol' => '#606060',
   	'footertxtcol' => '#DDDDDD',
   	'footertxtlinkcol' => '#DDDDDD',
   	'footertxtlinkhvrcol' => '#DDDDDD',
   	'addwishlisttext' => '+ Add To Wish List',
   	'onwishlisttext' => 'On Your Wish List',
   	'delwishlisttext' => 'Remove From Wish List',
   	'wishlisttext' => 'Wish List',
   	'wishlistsidebar' => '0',
   	'wlshareoptions' => 'F,T,P',
   	'wlsharetext' => 'Check out my Wish List',
   	'newmemberadminmail' => '1',
   	'newmembermail' => '1',
   	'newmembermailsubj' => '[{SITE_NAME}] Your username and password',
   	'newmembermailbody' => "Thank you for registering with: {SITE_NAME}\r\nUsername: {USERNAME}\r\nPassword: {PASSWORD}\r\n{SITE_URL}\r\n",
   	'custdefaultimg' => '',
   	'titlelinks' => '1',
   	'imagelinks' => '0',
   	'buttonlinks' => '0',
   	'newmemberaroption' => 'N',
   	'aweber_auth_code' => '',
   	'aweber_consumer_key' => '',
   	'aweber_consumer_secret' => '',
   	'aweber_access_key' => '',
   	'aweber_access_secret' => '',
   	'aweber_list' => '',
   	'getresponse_api_key' => '',
   	'getresponse_campaign' => '',
   	'ar_formurl' => '',
   	'ar_form' => '',
   	'ar_formfldemail' => '',
   	'ar_formfldname' => '',
  	   'homepagescripts' => ''
	);

	return $default_theme_options;
}

$sidebar_options = array(
	'0' => array('label' => __('Off', 'imwb_zonpress')),
	'1' => array('label' => __('Left', 'imwb_zonpress')),
	'2' => array('label' => __('Right', 'imwb_zonpress'))
);

$yesno_options = array(
	'1' => array('label' => __('Yes', 'imwb_zonpress')),
	'0' => array('label' => __('No', 'imwb_zonpress'))
);

$listorder_options = array(
	'0' => array('label' => __('Most Popular (CTR)', 'imwb_zonpress')),
	'1' => array('label' => __('Most Recent', 'imwb_zonpress'))
);

$postlistorder_options = array(
	'0' => array('label' => __('Popular (CTR)', 'imwb_zonpress')),
	'1' => array('label' => __('Newest', 'imwb_zonpress')),
   '2' => array('label' => __('Highest Price', 'imwb_zonpress')),
   '3' => array('label' => __('Lowest Price', 'imwb_zonpress'))
);

$links_options = array(
	'0' => array('label' => __('Product Url', 'imwb_zonpress')),
	'1' => array('label' => __('Post', 'imwb_zonpress'))
);

$comments_options = array(
	'0' => array('label' => __('Wordpress Comments', 'imwb_zonpress')),
	'1' => array('label' => __('Facebook Comments', 'imwb_zonpress')),
   '2' => array('label' => __('Wordpress & Facebook Comments', 'imwb_zonpress')),
   '3' => array('label' => __('None', 'imwb_zonpress'))
);

// Function to get a list of the Blogs pages and return a <option> list of them
function csp_get_blog_pages($parentId = 0, $selected=array(), $level = 0) {
   $retStr = '';

   if(!is_array($selected))
      $selected = array();

   $pages = get_pages('parent='.$parentId.'&child_of='.$parentId);
   if(count($pages) > 0){
      foreach($pages as $page){
        $sel = false;
        if(in_array($page->ID,$selected))
        		$sel = true;
        $retStr.= "<option value='" . $page->ID . "' ".(($sel)?' selected="selected"':'').'>'.str_repeat('  - ', $level).wp_specialchars($page->post_title).'</option>'.csp_get_blog_pages($page->ID, $selected, $level+1);
      }
   }

   return $retStr;
}

// Function to get a list of the Blogs Categories and return a <option> list of them
function csp_get_blog_categories($parentId = 0, $selected=array(), $level = 0) {
   $retStr = '';

   if(!is_array($selected))
      $selected = array();

	$cats = get_categories('child_of='.$parentId.'&parent='.$parentId.'&hide_empty=0');
   if(count($cats) > 0){
      foreach($cats as $cat){
        $sel = false;
        if(in_array($cat->cat_ID,$selected))
        		$sel = true;
        $retStr.= "<option value='" . $cat->cat_ID . "' ".(($sel)?' selected="selected"':'').'>'.str_repeat('  - ', $level).wp_specialchars($cat->cat_name).'</option>'.csp_get_blog_categories($cat->cat_ID, $selected, $level+1);
      }
   }

   return $retStr;
}

/**
 * Create the options page
 */
function imwb_zonpress_theme_options_do_page() {
   global $sidebar_options, $yesno_options, $listorder_options, $links_options, $postlistorder_options, $comments_options;

	?>

	<div class="wrap">

   <?php if(isset($_REQUEST['page']) && $_REQUEST['page'] == 'imwb_zonpress_theme_options' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'update') : ?>
      <div class="imwb_cabar_active_panel"><p><strong><?php _e( 'Options saved', 'imwb_zonpress' ); ?></strong></p></div>
   <?php endif; ?>
	<div id="imwb_plugin_options_editor">

		<?php screen_icon(); echo "<h2>" . __( 'Theme Options', 'imwb_zonpress' ) . ''; ?>

		<form method="post" action="" enctype="multipart/form-data">
			<?php settings_fields( 'imwb_zonpress_options' ); ?>
			<input type="hidden" name="color-scheme" value="">
			<input type="hidden" name="aweber-auth" value="">
			<fieldset><legend><?php _e( 'Color Schemes', 'imwb_zonpress' ); ?></legend>
			   <input id="scheme-white" type="button" class="button scheme white" value="<?php _e( 'White (Default)', 'imwb_zonpress' ); ?>" />
   			   <input id="scheme-blue" type="button" class="button scheme blue" value="<?php _e( 'Blue', 'imwb_zonpress' ); ?>" />
 			   <input id="scheme-coffee" type="button" class="button scheme coffee" value="<?php _e( 'Coffee Shop', 'imwb_zonpress' ); ?>" />
 			   <input id="scheme-fairy" type="button" class="button scheme fairy" value="<?php _e( 'Fairy Floss', 'imwb_zonpress' ); ?>" />
  			   <input id="scheme-red" type="button" class="button scheme red" value="<?php _e( 'Red', 'imwb_zonpress' ); ?>" />
			</fieldset>
         <br>
         <table class="widefat">
          <thead>
           <tr>
            <th scope="col" colspan="2"><?php _e( 'General Options', 'imwb_zonpress' ); ?></th>
           </tr>
          </thead>
           <tbody style="display: table-row-group;">
 				<tr valign="top"><td width="350px"><?php _e( 'Favicon', 'imwb_zonpress' ); ?></td>
 					<td>
 						<input id="imwb_zonpress_theme_options[faviconurl]" class="regular-text" type="text" name="imwb_zonpress_theme_options[faviconurl]" value="<?php esc_attr_e( imwb_zonpress_get_option('faviconurl') ); ?>" />
 						<label class="description" for="imwb_zonpress_theme_options[faviconurl]"><?php _e( 'Favicon url [16x16]', 'imwb_zonpress' ); ?></label><br>
 						<input type="file" name="favicon_img"  id="favicon_img" />
 					</td>
 				</tr>
 				<tr>
 				<td><?php _e( 'Default Open Graph Image', 'imwb_zonpress' ); ?></td>
 				<td>
 				<input id="imwb_zonpress_theme_options[defOGPImg]" class="regular-text" type="text" name="imwb_zonpress_theme_options[defOGPImg]" value="<?php esc_attr_e( imwb_zonpress_get_option('defOGPImg') ); ?>" />
 				<label class="description" for="imwb_zonpress_theme_options[defOGPImg]"><?php _e( 'A site image or logo to use if no image found when sharing content with social sites', 'imwb_zonpress' ); ?></label><br>
 				<input type="file" name="file_defOGPImg"/>
 				</td>
 				</tr>
 				<tr valign="top"><td width="350px"><?php _e( 'Custom Default Post Image ', 'imwb_zonpress' ); ?></td>
 					<td>
 						<input id="imwb_zonpress_theme_options[custdefaultimg]" class="regular-text" type="text" name="imwb_zonpress_theme_options[custdefaultimg]" value="<?php esc_attr_e( imwb_zonpress_get_option('custdefaultimg') ); ?>" /> <label class="description" for="imwb_zonpress_theme_options[custdefaultimg]"><?php _e( 'Recommended Size [300x250]', 'imwb_zonpress' ); ?></label>
 						<br>
 						<input type="file" name="custdefault_img"  id="custdefault_img" />
 					</td>
 				</tr>
 				<tr><td colspan="2"><strong><?php _e( 'Social Buttons', 'imwb_zonpress' ); ?></strong></td></tr>
 				<tr><td width="350px"><?php _e( 'Hide', 'imwb_zonpress' ); ?></td>
 				 	 <td><input id="imwb_zonpress_theme_options[hidesocialbtns]" type="checkbox" name="imwb_zonpress_theme_options[hidesocialbtns]" value="Y" <?php echo imwb_zonpress_get_option('hidesocialbtns') == "Y" ? "checked='Yes'" : "" ?> />

 				 	</td>
 				</tr>
 				<tr><td width="350px"><?php _e( 'Twitter Username', 'imwb_zonpress' ); ?></td>
 					 <td><input type="text" name="imwb_zonpress_theme_options[twitteruser]" value="<?php echo esc_attr( imwb_zonpress_get_option('twitteruser') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
 					</td>
 				</tr>
 				<tr><td width="350px"><?php _e( 'Facebook Username', 'imwb_zonpress' ); ?></td>
 					 <td><input type="text" name="imwb_zonpress_theme_options[facebookuser]" value="<?php echo esc_attr( imwb_zonpress_get_option('facebookuser') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
 					</td>
 				</tr>
 				<tr><td width="350px"><?php _e( 'Google+ Number', 'imwb_zonpress' ); ?></td>
 					 <td><input type="text" name="imwb_zonpress_theme_options[googleuser]" value="<?php echo esc_attr( imwb_zonpress_get_option('googleuser') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
 					</td>
 				</tr>
 				<tr><td width="350px"><?php _e( 'Pinterest Username', 'imwb_zonpress' ); ?></td>
 					 <td><input type="text" name="imwb_zonpress_theme_options[pinterestuser]" value="<?php echo esc_attr( imwb_zonpress_get_option('pinterestuser') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
 					</td>
 				</tr>
            <tr><td width="350px"><?php _e( 'Reddit Username', 'imwb_zonpress' ); ?></td>
            	 <td><input type="text" name="imwb_zonpress_theme_options[reddituser]" value="<?php echo esc_attr( imwb_zonpress_get_option('reddituser') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
            	</td>
            </tr>
            <tr><td width="350px"><?php _e( 'RSS Feed URL', 'imwb_zonpress' ); ?></td>
            	 <td><input type="text" name="imwb_zonpress_theme_options[rssfeedurl]" value="<?php echo esc_attr( imwb_zonpress_get_option('rssfeedurl') ); ?>" size="30"/><?php _e( ' - Leave blank if not required', 'imwb_zonpress' ); ?>
            	</td>
            </tr>
          </tbody>
 			</table>
 <br>
         <table class="widefat">
          <thead>
           <tr>
            <th scope="col" colspan="2"><?php _e( 'Header, Search, Navigation & Menus', 'imwb_zonpress' ); ?></th>
           </tr>
          </thead>
           <tbody style="display: table-row-group;">
           <tr><td width="350px"><?php _e( 'Header Background Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[headerbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('headerbgcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'User/Account Top Menu Text Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[sitemenutxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('sitemenutxtcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td colspan="2"><strong><?php _e( 'Main Menu', 'imwb_zonpress' ); ?></strong></td></tr>
           <tr><td width="350px"><?php _e( 'Hide Menu', 'imwb_zonpress' ); ?></td>
           	 <td><input id="imwb_zonpress_theme_options[hidemenu]" type="checkbox" name="imwb_zonpress_theme_options[hidemenu]" value="Y" <?php echo imwb_zonpress_get_option('hidemenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Text Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[menutxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('menutxtcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Selected Menu Text Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[menuseltxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('menuseltxtcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Background Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[menubgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('menubgcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
            <tr><td width="350px"><?php _e( 'Whats New Menu Option', 'imwb_zonpress' ); ?></td>
            	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[mrsmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('mrsmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[mrsmenu]" type="checkbox" name="imwb_zonpress_theme_options[mrsmenu]" value="Y" <?php echo imwb_zonpress_get_option('mrsmenu') == "Y" ? "checked='Yes'" : "" ?> /><br>
            	   <?php _e( 'Title Text', 'imwb_zonpress' ); ?>&nbsp;&nbsp;&nbsp;<input type="text" name="imwb_zonpress_theme_options[mrsmenutitle]" value="<?php echo esc_attr( imwb_zonpress_get_option('mrsmenutitle') ); ?>" size="30"/>

            	</td>
            </tr>
            <tr><td width="350px"><?php _e( 'Categories to include on menu', 'imwb_zonpress' ); ?></td>
            	 <td><select size="10"  multiple="multiple"  style="width:340px; height:auto;" name="imwb_zonpress_theme_options[includecats][]" id="imwb_zonpress_theme_options[includecats]" >
            <?php
            			$currentcats = explode(",", htmlspecialchars(imwb_zonpress_get_option('includecats')) );
                     echo csp_get_blog_categories(0, $currentcats);

            ?></select>   <br>
            <a href="javascript:void(0)" onclick="imwb_ms_unselectAll(document.getElementById('imwb_zonpress_theme_options[includecats]'))"><?php _e('Unselect All','imwb_zonpress'); ?></a>
            	 </td>
            </tr>
            <tr><td width="350px"><?php _e( 'Other Categories Drop Down Menu Option', 'imwb_zonpress' ); ?></td>
            	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[othercatmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('othercatmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[othercatmenu]" type="checkbox" name="imwb_zonpress_theme_options[othercatmenu]" value="Y" <?php echo imwb_zonpress_get_option('othercatmenu') == "Y" ? "checked='Yes'" : "" ?> />
            	</td>
            </tr>
            <tr><td width="350px"><?php _e( 'Categories to Exclude from Drop Down Menu', 'imwb_zonpress' ); ?><br><small><?php _e( 'Categories included on menu will be automatically excluded', 'imwb_zonpress' ); ?></small></td>
            	 <td><select size="10"  multiple="multiple"  style="width:340px; height:auto;" name="imwb_zonpress_theme_options[excludecats][]" id="imwb_zonpress_theme_options[excludecats]" >
				<?php
							$currentcats = explode(",", htmlspecialchars(imwb_zonpress_get_option('excludecats')) );
                     echo csp_get_blog_categories(0, $currentcats);

				?></select>   <br>
				<a href="javascript:void(0)" onclick="imwb_ms_unselectAll(document.getElementById('imwb_zonpress_theme_options[excludecats]'))"><?php _e('Unselect All','imwb_zonpress'); ?></a>
            	 </td>
            </tr>
           <tr><td colspan="2"><strong><?php _e( 'Posts Menu', 'imwb_zonpress' ); ?></strong></td></tr>
           <tr><td width="350px"><?php _e( 'Hide Menu', 'imwb_zonpress' ); ?></td>
           	 <td><input id="imwb_zonpress_theme_options[posthidemenu]" type="checkbox" name="imwb_zonpress_theme_options[posthidemenu]" value="Y" <?php echo imwb_zonpress_get_option('posthidemenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Text Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postmenutxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postmenutxtcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Selected Menu Text Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postmenuseltxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postmenuseltxtcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Background Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postmenubgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postmenubgcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Newest Menu Option', 'imwb_zonpress' ); ?></td>
           	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[postmrsmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('postmrsmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[postmrsmenu]" type="checkbox" name="imwb_zonpress_theme_options[postmrsmenu]" value="Y" <?php echo imwb_zonpress_get_option('postmrsmenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Popular Menu Option', 'imwb_zonpress' ); ?></td>
           	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[posttrsmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('posttrsmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[posttrsmenu]" type="checkbox" name="imwb_zonpress_theme_options[posttrsmenu]" value="Y" <?php echo imwb_zonpress_get_option('posttrsmenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Highest Price Menu Option', 'imwb_zonpress' ); ?></td>
           	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[posthpsmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('posthpsmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[posthpsmenu]" type="checkbox" name="imwb_zonpress_theme_options[posthpsmenu]" value="Y" <?php echo imwb_zonpress_get_option('posthpsmenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Lowest Price Menu Option', 'imwb_zonpress' ); ?></td>
           	 <td><?php _e( 'Menu Text', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[postlpsmenutxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('postlpsmenutxt') ); ?>" size="30"/> <?php _e( '- Don\'t Show', 'imwb_zonpress' ); ?> <input id="imwb_zonpress_theme_options[postlpsmenu]" type="checkbox" name="imwb_zonpress_theme_options[postlpsmenu]" value="Y" <?php echo imwb_zonpress_get_option('postlpsmenu') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td colspan="2"><strong><?php _e( 'Posts Navigation', 'imwb_zonpress' ); ?></strong></td></tr>
           <tr valign="top"><td width="350px"><?php _e( 'Links Open In New Window', 'imwb_zonpress' ); ?></td>
           	<td>
           		<select id="imwb_zonpress_theme_options[linknewwin]" class="regular-text" type="text" name="imwb_zonpress_theme_options[linknewwin]" />
           		<?php
           		 foreach ($yesno_options as $key => $value) {
                     $selected = (imwb_zonpress_get_option('linknewwin') == $key) ? " selected" : "";
           		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
           		 }
           		?>
           		</select>
           	</td>
           </tr>
           <tr valign="top"><td width="350px"><?php _e( 'Title Links go to product source url or post', 'imwb_zonpress' ); ?></td>
           <td>
           	<select id="imwb_zonpress_theme_options[titlelinks]" class="regular-text" type="text" name="imwb_zonpress_theme_options[titlelinks]" />
           	<?php
           	 foreach ($links_options as $key => $value) {
                  $selected = (imwb_zonpress_get_option('titlelinks') == $key) ? " selected" : "";
           	    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
           	 }
           	?>
           	</select>
           </td>
           </tr>
           <tr valign="top"><td width="350px"><?php _e( 'Image Links go to product source url or post', 'imwb_zonpress' ); ?></td>
           <td>
           	<select id="imwb_zonpress_theme_options[imagelinks]" class="regular-text" type="text" name="imwb_zonpress_theme_options[imagelinks]" />
           	<?php
           	 foreach ($links_options as $key => $value) {
                  $selected = (imwb_zonpress_get_option('imagelinks') == $key) ? " selected" : "";
           	    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
           	 }
           	?>
           	</select>
           </td>
           </tr>
           <tr valign="top"><td width="350px"><?php _e( 'Product Button goes to product source url or post', 'imwb_zonpress' ); ?></td>
           <td>
           	<select id="imwb_zonpress_theme_options[buttonlinks]" class="regular-text" type="text" name="imwb_zonpress_theme_options[buttonlinks]" />
           	<?php
           	 foreach ($links_options as $key => $value) {
                  $selected = (imwb_zonpress_get_option('buttonlinks') == $key) ? " selected" : "";
           	    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
           	 }
           	?>
           	</select>
           </td>
           </tr>
           <tr><td colspan="2"><strong><?php _e( 'Search Form', 'imwb_zonpress' ); ?></strong></td></tr>
           <tr><td width="350px"><?php _e( 'Hide Search Form', 'imwb_zonpress' ); ?></td>
           	 <td><input id="imwb_zonpress_theme_options[hidesearch]" type="checkbox" name="imwb_zonpress_theme_options[hidesearch]" value="Y" <?php echo imwb_zonpress_get_option('hidesearch') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Default Search Field Text', 'imwb_zonpress' ); ?></td>
           	 <td><input type="text" name="imwb_zonpress_theme_options[searchtext]" value="<?php echo esc_attr( imwb_zonpress_get_option('searchtext') ); ?>" size="30"/>

           	</td>
           </tr>
          </tbody>
 			</table>
 <br>
        <table class="widefat">
         <thead>
          <tr>
           <th scope="col" colspan="2"><?php _e( 'Sidebar & Widgets Options', 'imwb_zonpress' ); ?></th>
          </tr>
         </thead>
          <tbody style="display: table-row-group;">
          <tr><td width="350px"><?php _e( 'Sidebar Background Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[sidebarbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('sidebarbgcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Widget Title Background Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[widgettitlebgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('widgettitlebgcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Widget Title Text Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[widgettitletxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('widgettitletxtcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
         </tbody>
			</table>
<br>
			<table class="widefat">
          <thead>
           <tr>
            <th scope="col" colspan="2"><?php _e( 'Home Page', 'imwb_zonpress' ); ?></th>
           </tr>
          </thead>
          <tbody style="display: table-row-group;">
         <tr><td width="350px"><?php _e( 'Hide Price', 'imwb_zonpress' ); ?></td>
        		 <td><input id="imwb_zonpress_theme_options[fphideprice]" type="checkbox" name="imwb_zonpress_theme_options[fphideprice]" value="Y" <?php echo imwb_zonpress_get_option('fphideprice') == "Y" ? "checked='Yes'" : "" ?> />
   
        		</td>
          </tr>
          <tr><td colspan="2"><strong><?php _e( 'Featured Posts Rotator', 'imwb_zonpress' ); ?></strong></td>
          <tr><td width="350px"><?php _e( 'Hide Rotator', 'imwb_zonpress' ); ?></td>
           	 <td><input id="imwb_zonpress_theme_options[hiderotator]" type="checkbox" name="imwb_zonpress_theme_options[hiderotator]" value="Y" <?php echo imwb_zonpress_get_option('hiderotator') == "Y" ? "checked='Yes'" : "" ?> />

           	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Delay between automatically cycling an item', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input type="text" name="imwb_zonpress_theme_options[delayrotator]" value="<?php echo esc_attr( imwb_zonpress_get_option('delayrotator') ); ?>" size="5"/> <?php _e( 'seconds - 0 = no automatic cycle', 'imwb_zonpress' ); ?>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Show at most', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input type="text" name="imwb_zonpress_theme_options[postsperrotator]" value="<?php echo esc_attr( imwb_zonpress_get_option('postsperrotator') ); ?>" size="5"/> <?php _e( 'posts', 'imwb_zonpress' ); ?>
          	</td>
          </tr>

          <tr valign="top"><td width="350px"><?php _e( 'Default Listing Order', 'imwb_zonpress' ); ?></td>
         	<td>
         		<select id="imwb_zonpress_theme_options[fplistorder]" class="regular-text" type="text" name="imwb_zonpress_theme_options[fplistorder]" />
         		<?php
         		 foreach ($listorder_options as $key => $value) {
                   $selected = (imwb_zonpress_get_option('fplistorder') == $key) ? " selected" : "";
         		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
         		 }
         		?>
         		</select>
         	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Exclude Posts from the Following Categories', 'imwb_zonpress' ); ?></td>
          	 <td><select size="10"  multiple="multiple"  style="width:340px; height:auto;" name="imwb_zonpress_theme_options[fpexcludecats][]" id="imwb_zonpress_theme_options[fpexcludecats]" >
          <?php
          			$currentcats = explode(",", htmlspecialchars(imwb_zonpress_get_option('fpexcludecats')) );
                   echo csp_get_blog_categories(0, $currentcats);

          ?></select>   <br>
          <a href="javascript:void(0)" onclick="imwb_ms_unselectAll(document.getElementById('imwb_zonpress_theme_options[fpexcludecats]'))"><?php _e('Unselect All','imwb_zonpress'); ?></a>
          	 </td>
          </tr>
          <tr><td width="350px"><?php _e( 'Background Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[fpbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fpbgcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Border Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[fpbdrcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fpbdrcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Title Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[fptitlecol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fptitlecol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	   &nbsp;&nbsp;<?php _e( 'On Hover', 'imwb_zonpress' ); ?> <input class="color-input" type="text" name="imwb_zonpress_theme_options[fptitlehvrcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fptitlehvrcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Content Text Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[fpdesccol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fpdesccol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          </tr>
          <tr><td colspan="2"><strong><?php _e( 'Posts', 'imwb_zonpress' ); ?></strong></td>
          <tr valign="top"><td width="350px"><?php _e( 'Default Listing Order', 'imwb_zonpress' ); ?></td>
          	<td>
          		<select id="imwb_zonpress_theme_options[listorder]" class="regular-text" type="text" name="imwb_zonpress_theme_options[listorder]" />
          		<?php
          		 foreach ($postlistorder_options as $key => $value) {
                    $selected = (imwb_zonpress_get_option('listorder') == $key) ? " selected" : "";
          		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
          		 }
          		?>
          		</select>
          	</td>
          </tr>
           <tr><td width="350px"><?php _e( 'Exclude Posts from the Following Categories', 'imwb_zonpress' ); ?></td>
           	 <td><select size="10"  multiple="multiple"  style="width:340px; height:auto;" name="imwb_zonpress_theme_options[hpexcludecats][]" id="imwb_zonpress_theme_options[hpexcludecats]" >
           <?php
           			$currentcats = explode(",", htmlspecialchars(imwb_zonpress_get_option('hpexcludecats')) );
                    echo csp_get_blog_categories(0, $currentcats);
 
           ?></select>   <br>
           <a href="javascript:void(0)" onclick="imwb_ms_unselectAll(document.getElementById('imwb_zonpress_theme_options[hpexcludecats]'))"><?php _e('Unselect All','imwb_zonpress'); ?></a>
           	 </td>
           </tr>         
				<tr valign="top"><td width="350px"><?php _e( 'Show Post Title', 'imwb_zonpress' ); ?></td>
					<td>
						<select id="imwb_zonpress_theme_options[showtitle]" class="regular-text" type="text" name="imwb_zonpress_theme_options[showtitle]" />
						<?php
						 foreach ($yesno_options as $key => $value) {
				          $selected = (imwb_zonpress_get_option('showtitle') == $key) ? " selected" : "";
						    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
						 }
						?>
						</select>
					</td>
				</tr>
				<tr valign="top"><td width="350px"><?php _e( 'Post Content', 'imwb_zonpress' ); ?></td>
					<td><input id="imwb_zonpress_theme_options[postcontent]" type="radio" name="imwb_zonpress_theme_options[postcontent]" value="N" <?php echo imwb_zonpress_get_option('postcontent') == "N" ? "checked='Yes'" : "" ?> /> <?php _e( 'Don\'t show post content.', 'imwb_zonpress' ); ?><br class="clear">
					<input id="imwb_zonpress_theme_options[postcontent]" type="radio" name="imwb_zonpress_theme_options[postcontent]" value="E" <?php echo imwb_zonpress_get_option('postcontent') == "E" ? "checked='Yes'" : "" ?> /> <?php _e( 'Show the post excerpt - If no explicit excerpt for a post, an automatic excerpt of the first 55 words of content will be used', 'imwb_zonpress' ); ?><br>
					<input id="imwb_zonpress_theme_options[postcontent]" type="radio" name="imwb_zonpress_theme_options[postcontent]" value="C" <?php echo imwb_zonpress_get_option('postcontent') == "C" ? "checked='Yes'" : "" ?> /> <?php _e( 'Custom post excerpt - Show the first', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[postchars]" value="<?php echo imwb_zonpress_get_option('postchars');?>" size=5 <?php echo imwb_zonpress_get_option('postcontent') != "C" ? "readonly" : "" ?>> <?php _e( 'words of the post content.', 'imwb_zonpress' ); ?>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Excerpt More Text Link', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input type="text" name="imwb_zonpress_theme_options[postmoretext]" value="<?php echo esc_attr( imwb_zonpress_get_option('postmoretext') ); ?>"/>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Post Background Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postbgcol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Post Title Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[posttitlecol]" value="<?php echo esc_attr( imwb_zonpress_get_option('posttitlecol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					   &nbsp;&nbsp;<?php _e( 'On Hover', 'imwb_zonpress' ); ?> <input class="color-input" type="text" name="imwb_zonpress_theme_options[posttitlehvrcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('posttitlehvrcol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Post Content Text Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postdesccol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postdesccol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Price Text Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[fppricecol]" value="<?php echo esc_attr( imwb_zonpress_get_option('fppricecol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Product Button Text', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input type="text" name="imwb_zonpress_theme_options[postprdbtntxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('postprdbtntxt') ); ?>"/>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Product Button Text Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postprdbtntxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postprdbtntxtcol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					</td>
				</tr>
				<tr><td width="350px"><?php _e( 'Product Button Background Color', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input class="color-input" type="text" name="imwb_zonpress_theme_options[postprdbtnbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postprdbtnbgcol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
					   &nbsp;&nbsp;<?php _e( 'On Hover', 'imwb_zonpress' ); ?> <input class="color-input" type="text" name="imwb_zonpress_theme_options[postprdbtnbghvrcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('postprdbtnbghvrcol') ); ?>"/>
					   <input type='button' class='pickcolor button-secondary' value='Select Color'>
					   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>

					</td>
				</tr>

        </tbody>
			</table>
<br>
			<table class="widefat">
          <thead>
           <tr>
            <th scope="col" colspan="2"><?php _e( 'Category Page', 'imwb_zonpress' ); ?></th>
           </tr>
          </thead>
          <tbody style="display: table-row-group;">
          <tr valign="top"><td width="350px"><?php _e( 'Sidebar Widget', 'imwb_zonpress' ); ?></td>
          	<td>
          		<select id="imwb_zonpress_theme_options[catsidebar]" class="regular-text" type="text" name="imwb_zonpress_theme_options[catsidebar]" />
          		<?php
          		 foreach ($sidebar_options as $key => $value) {
                    $selected = (imwb_zonpress_get_option('catsidebar') == $key) ? " selected" : "";
          		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
          		 }
          		?>
          		</select>
          	</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Hide Price', 'imwb_zonpress' ); ?></td>
           		 <td><input id="imwb_zonpress_theme_options[hidecatprice]" type="checkbox" name="imwb_zonpress_theme_options[hidecatprice]" value="Y" <?php echo imwb_zonpress_get_option('hidecatprice') == "Y" ? "checked='Yes'" : "" ?> />

           		</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Hide Description', 'imwb_zonpress' ); ?></td>
           		 <td><input id="imwb_zonpress_theme_options[hidecatdesc]" type="checkbox" name="imwb_zonpress_theme_options[hidecatdesc]" value="Y" <?php echo imwb_zonpress_get_option('hidecatdesc') == "Y" ? "checked='Yes'" : "" ?> />

           		</td>
          </tr>
          <tr><td width="350px"><?php _e( 'Show at most', 'imwb_zonpress' ); ?></td>
         	 <td>
         	   <input type="text" name="imwb_zonpress_theme_options[postspercat]" value="<?php echo esc_attr( imwb_zonpress_get_option('postspercat') ); ?>" size="5"/> <?php _e( 'posts', 'imwb_zonpress' ); ?>
         	</td>
          </tr>
          </tbody>
          </table>
<br>
			<table class="widefat">
         <thead>
          <tr>
           <th scope="col" colspan="2"><?php _e( 'Single Post and Pages', 'imwb_zonpress' ); ?></th>
          </tr>
         </thead>
         <tbody style="display: table-row-group;">
         <tr><td colspan="2"><strong><?php _e( 'Single Post', 'imwb_zonpress' ); ?></strong></td></tr>
         <tr><td width="350px"><?php _e( 'Hide Featured Posts Thumbnails', 'imwb_zonpress' ); ?></td>
          		 <td><input id="imwb_zonpress_theme_options[hideptthumbs]" type="checkbox" name="imwb_zonpress_theme_options[hideptthumbs]" value="Y" <?php echo imwb_zonpress_get_option('hideptthumbs') == "Y" ? "checked='Yes'" : "" ?> />

          		</td>
         </tr>
         <tr><td width="350px"><?php _e( 'Featured Posts Thumbnails Show at most', 'imwb_zonpress' ); ?></td>
         	 <td>
         	   <input type="text" name="imwb_zonpress_theme_options[ptthumbsshown]" value="<?php echo esc_attr( imwb_zonpress_get_option('ptthumbsshown') ); ?>" size="5"/> <?php _e( 'thumbnails', 'imwb_zonpress' ); ?>
         	</td>
         </tr>
         <tr valign="top"><td width="350px"><?php _e( 'Sidebar Widget', 'imwb_zonpress' ); ?></td>
         	<td>
         		<select id="imwb_zonpress_theme_options[postsidebar]" class="regular-text" type="text" name="imwb_zonpress_theme_options[postsidebar]" />
         		<?php
         		 foreach ($sidebar_options as $key => $value) {
                   $selected = (imwb_zonpress_get_option('postsidebar') == $key) ? " selected" : "";
         		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
         		 }
         		?>
         		</select>
         	</td>
         </tr>
         <tr><td width="350px"><?php _e( 'Product Button Text', 'imwb_zonpress' ); ?></td>
         	 <td>
         	   <input type="text" name="imwb_zonpress_theme_options[ptprdbtntxt]" value="<?php echo esc_attr( imwb_zonpress_get_option('ptprdbtntxt') ); ?>"/>
         	</td>
         </tr>
           <tr><td width="350px"><?php _e( 'Hide Title', 'imwb_zonpress' ); ?></td>
            		 <td><input id="imwb_zonpress_theme_options[hidepttitle]" type="checkbox" name="imwb_zonpress_theme_options[hidepttitle]" value="Y" <?php echo imwb_zonpress_get_option('hidepttitle') == "Y" ? "checked='Yes'" : "" ?> />

            		</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Hide Entry Details', 'imwb_zonpress' ); ?></td>
           		 <td><input id="imwb_zonpress_theme_options[hideptdetails]" type="checkbox" name="imwb_zonpress_theme_options[hideptdetails]" value="Y" <?php echo imwb_zonpress_get_option('hideptdetails') == "Y" ? "checked='Yes'" : "" ?> />

           		</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Hide Price', 'imwb_zonpress' ); ?></td>
             		 <td><input id="imwb_zonpress_theme_options[hideptprice]" type="checkbox" name="imwb_zonpress_theme_options[hideptprice]" value="Y" <?php echo imwb_zonpress_get_option('hideptprice') == "Y" ? "checked='Yes'" : "" ?> />
   
             		</td>
            </tr>
            <tr><td width="350px"><?php _e( 'Hide Social Sharing Buttons', 'imwb_zonpress' ); ?></td>
             		 <td><input id="imwb_zonpress_theme_options[hideptlikestats]" type="checkbox" name="imwb_zonpress_theme_options[hideptlikestats]" value="Y" <?php echo imwb_zonpress_get_option('hideptlikestats') == "Y" ? "checked='Yes'" : "" ?> />

             		</td>
            </tr>
         	<tr valign="top"><td width="350px"><?php _e( 'Social Sharing Buttons', 'imwb_zonpress' ); ?></td>
         		<td>
<?php
$shareoptions = explode(",", imwb_zonpress_get_option('shareoptions'));
?>
         		<input id="imwb_zonpress_theme_options[shareoptions]" type="checkbox" name="imwb_zonpress_theme_options[shareoptions][]" value="F" <?php echo in_array("F", $shareoptions)  ? "checked='Yes'" : "" ?> />	<?php _e( 'Facebook', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[shareoptions]" type="checkbox" name="imwb_zonpress_theme_options[shareoptions][]" value="T" <?php echo in_array("T", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Twitter', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[shareoptions]" type="checkbox" name="imwb_zonpress_theme_options[shareoptions][]" value="P" <?php echo in_array("P", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Pinterest', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[shareoptions]" type="checkbox" name="imwb_zonpress_theme_options[shareoptions][]" value="L" <?php echo in_array("L", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'LinkedIn', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[shareoptions]" type="checkbox" name="imwb_zonpress_theme_options[shareoptions][]" value="G" <?php echo in_array("G", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Google+', 'imwb_zonpress' ); ?>


				</td>
				</tr>
				<tr valign="top"><td width="350px"><?php _e( 'Comments Type', 'imwb_zonpress' ); ?></td>
					<td>
						<select id="imwb_zonpress_theme_options[commenttype]" class="regular-text" type="text" name="imwb_zonpress_theme_options[commenttype]" />
						<?php
						 foreach ($comments_options as $key => $value) {
				          $selected = (imwb_zonpress_get_option('commenttype') == $key) ? " selected" : "";
						    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
						 }
						?>
						</select>
					</td>
				</tr>
				<tr class="comment-type-fb" <?php echo (imwb_zonpress_get_option('commenttype') == '0' || imwb_zonpress_get_option('commenttype') == '3')? 'style="display: none;"' : ""; ?>><td width="350px"><?php _e( 'Facebook App Id', 'imwb_zonpress' ); ?></td>
					 <td>
					   <input type="text" name="imwb_zonpress_theme_options[fbappid]" value="<?php echo esc_attr( imwb_zonpress_get_option('fbappid') ); ?>" size="15"/>
					</td>
				</tr>
           <tr class="comment-type-wp" <?php echo (imwb_zonpress_get_option('commenttype') == '1' || imwb_zonpress_get_option('commenttype') == '3') ? 'style="display: none;"' : ""; ?>><td width="350px"><?php _e( 'Hide Wordpress Comments Timestamp', 'imwb_zonpress' ); ?></td>
            		 <td><input id="imwb_zonpress_theme_options[hideptcommenttime]" type="checkbox" name="imwb_zonpress_theme_options[hideptcommenttime]" value="Y" <?php echo imwb_zonpress_get_option('hideptcommenttime') == "Y" ? "checked='Yes'" : "" ?> />

            		</td>
           </tr>
              <tr><td colspan="2"><strong><?php _e( 'Single Page', 'imwb_zonpress' ); ?></strong></td>
              </tr>
              <tr valign="top"><td width="350px"><?php _e( 'Sidebar Widget', 'imwb_zonpress' ); ?></td>
              	<td>
              		<select id="imwb_zonpress_theme_options[pagesidebar]" class="regular-text" type="text" name="imwb_zonpress_theme_options[pagesidebar]" />
              		<?php
              		 foreach ($sidebar_options as $key => $value) {
                        $selected = (imwb_zonpress_get_option('pagesidebar') == $key) ? " selected" : "";
              		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
              		 }
              		?>
              		</select>
              	</td>
              </tr>
              <tr><td width="350px"><?php _e( 'Hide Title', 'imwb_zonpress' ); ?></td>
               		 <td><input id="imwb_zonpress_theme_options[hidepgtitle]" type="checkbox" name="imwb_zonpress_theme_options[hidepgtitle]" value="Y" <?php echo imwb_zonpress_get_option('hidepgtitle') == "Y" ? "checked='Yes'" : "" ?> />

               		</td>
              </tr>
              <tr><td width="350px"><?php _e( 'Hide Comments', 'imwb_zonpress' ); ?></td>
               		 <td><input id="imwb_zonpress_theme_options[hidepgcomments]" type="checkbox" name="imwb_zonpress_theme_options[hidepgcomments]" value="Y" <?php echo imwb_zonpress_get_option('hidepgcomments') == "Y" ? "checked='Yes'" : "" ?> />

               		</td>
              </tr>

          </tbody>
         </table>
         <br>
         	<table class="widefat">
           <thead>
            <tr>
             <th scope="col" colspan="2"><?php _e( 'Footer', 'imwb_zonpress' ); ?></th>
            </tr>
           </thead>
           <tbody style="display: table-row-group;">
           <tr><td width="350px"><?php _e( 'Hide Footer', 'imwb_zonpress' ); ?></td>
            	 <td><input id="imwb_zonpress_theme_options[hidefooter]" type="checkbox" name="imwb_zonpress_theme_options[hidefooter]" value="Y" <?php echo imwb_zonpress_get_option('hidefooter') == "Y" ? "checked='Yes'" : "" ?> />

            	</td>
           </tr>
           <tr><td width="350px"><?php _e( 'Footer Area Background Color', 'imwb_zonpress' ); ?></td>
           	 <td>
           	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[footerbgcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('footerbgcol') ); ?>"/>
           	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
           	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
           	</td>
           </tr>
          <tr><td width="350px"><?php _e( 'Footer Area Text Color', 'imwb_zonpress' ); ?></td>
          	 <td>
          	   <input class="color-input" type="text" name="imwb_zonpress_theme_options[footertxtcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('footertxtcol') ); ?>"/>
          	   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          	   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          	</td>
          	
          	<tr><td width="350px"><?php _e( 'Footer Area Text Link Color', 'imwb_zonpress' ); ?></td>
          		 <td>
          		   <input class="color-input" type="text" name="imwb_zonpress_theme_options[footertxtlinkcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('footertxtlinkcol') ); ?>"/>
          		   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          		   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          		   &nbsp;&nbsp;<?php _e( 'On Hover', 'imwb_zonpress' ); ?> <input class="color-input" type="text" name="imwb_zonpress_theme_options[footertxtlinkhvrcol]" value="<?php echo esc_attr( imwb_zonpress_get_option('footertxtlinkhvrcol') ); ?>"/>
          		   <input type='button' class='pickcolor button-secondary' value='Select Color'>
          		   <div style='z-index: 100; background:#eee; border:1px solid #ccc; position:absolute; display:none;'></div>
          		</td>
          	</tr>
          </tbody>
         	</table>
         	
            <br>
            <table class="widefat">
             <thead>
              <tr>
               <th scope="col" colspan="2"><?php _e( 'Membership Options', 'imwb_zonpress' ); ?></th>
              </tr>
             </thead>
              <tbody style="display: table-row-group;">
              <tr>
               <th scope="col" colspan="2"><?php _e( 'Wish List', 'imwb_zonpress' ); ?></th>
              </tr>
              <tr valign="top"><td width="350px"><?php _e( 'Wish List default text', 'imwb_zonpress' ); ?></td>
              <td>
               <input type="text" name="imwb_zonpress_theme_options[wishlisttext]" value="<?php echo esc_attr( imwb_zonpress_get_option('wishlisttext') ); ?>" size="15"/>
              </td>
              </tr>
              <tr valign="top"><td width="350px"><?php _e( 'Wish List action text', 'imwb_zonpress' ); ?></td>
              <td>
               Adding: <input type="text" name="imwb_zonpress_theme_options[addwishlisttext]" value="<?php echo esc_attr( imwb_zonpress_get_option('addwishlisttext') ); ?>" size="30"/> On List: <input type="text" name="imwb_zonpress_theme_options[onwishlisttext]" value="<?php echo esc_attr( imwb_zonpress_get_option('onwishlisttext') ); ?>" size="30"/> Removing: <input type="text" name="imwb_zonpress_theme_options[delwishlisttext]" value="<?php echo esc_attr( imwb_zonpress_get_option('delwishlisttext') ); ?>" size="30"/>

              </td>
              </tr>
              <tr valign="top"><td width="350px"><?php _e( 'Wish List Sidebar Widget', 'imwb_zonpress' ); ?></td>
              	<td>
              		<select id="imwb_zonpress_theme_options[wishlistsidebar]" class="regular-text" type="text" name="imwb_zonpress_theme_options[wishlistsidebar]" />
              		<?php
              		 foreach ($sidebar_options as $key => $value) {
                        $selected = (imwb_zonpress_get_option('wishlistsidebar') == $key) ? " selected" : "";
              		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
              		 }
              		?>
              		</select>
              	</td>
              </tr>
              <tr>
              	<tr valign="top"><td width="350px"><?php _e( 'Social Sharing Buttons', 'imwb_zonpress' ); ?></td>
              		<td>
     <?php
     $shareoptions = explode(",", imwb_zonpress_get_option('wlshareoptions'));
     ?>
              		<input id="imwb_zonpress_theme_options[wlshareoptions]" type="checkbox" name="imwb_zonpress_theme_options[wlshareoptions][]" value="F" <?php echo in_array("F", $shareoptions)  ? "checked='Yes'" : "" ?> />	<?php _e( 'Facebook', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[wlshareoptions]" type="checkbox" name="imwb_zonpress_theme_options[wlshareoptions][]" value="T" <?php echo in_array("T", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Twitter', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[wlshareoptions]" type="checkbox" name="imwb_zonpress_theme_options[wlshareoptions][]" value="P" <?php echo in_array("P", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Pinterest', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[wlshareoptions]" type="checkbox" name="imwb_zonpress_theme_options[wlshareoptions][]" value="L" <?php echo in_array("L", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'LinkedIn', 'imwb_zonpress' ); ?>&nbsp;&nbsp;<input id="imwb_zonpress_theme_options[wlshareoptions]" type="checkbox" name="imwb_zonpress_theme_options[wlshareoptions][]" value="G" <?php echo in_array("G", $shareoptions) ? "checked='Yes'" : "" ?> />	<?php _e( 'Google+', 'imwb_zonpress' ); ?>
     				</td>
     				</tr>
     				<tr valign="top"><td width="350px"><?php _e( 'Social Sharing text', 'imwb_zonpress' ); ?></td>
     				<td>
     				 <input type="text" name="imwb_zonpress_theme_options[wlsharetext]" value="<?php echo esc_attr( imwb_zonpress_get_option('wlsharetext') ); ?>" size="60"/>
     				</td>
     				</tr>
               <th scope="col" colspan="2"><?php _e( 'New Member', 'imwb_zonpress' ); ?></th>
              </tr>
            	<tr valign="top"><td width="350px"><?php _e( 'When new members register send email to Admin', 'imwb_zonpress' ); ?></td>
            	<td>
            		<select id="imwb_zonpress_theme_options[newmemberadminmail]" class="regular-text" type="text" name="imwb_zonpress_theme_options[newmemberadminmail]" />
            		<?php
            		 foreach ($yesno_options as $key => $value) {
            	       $selected = (imwb_zonpress_get_option('newmemberadminmail') == $key) ? " selected" : "";
            		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
            		 }
            		?>
            		</select>
            	</td>
            	</tr>
            	<tr valign="top"><td width="350px"><?php _e( 'When new members register send them welcome email', 'imwb_zonpress' ); ?></td>
            	<td>
            		<select id="imwb_zonpress_theme_options[newmembermail]" class="regular-text" type="text" name="imwb_zonpress_theme_options[newmembermail]" />
            		<?php
            		 foreach ($yesno_options as $key => $value) {
            	       $selected = (imwb_zonpress_get_option('newmembermail') == $key) ? " selected" : "";
            		    echo "<option value='{$key}'{$selected}>{$value['label']}</option>";
            		 }
            		?>
            		</select>
            	</td>
            	</tr>
            	<tr valign="top"><td width="350px"><?php _e( 'New user welcome email', 'imwb_zonpress' ); ?></td>
            	<td>
        	         <?php _e( 'Subject', 'imwb_zonpress' ); ?> <input type="text" name="imwb_zonpress_theme_options[newmembermailsubj]" value="<?php echo esc_attr( imwb_zonpress_get_option('newmembermailsubj') ); ?>" size="60"/>
            	</td>
            	</tr>
            	<tr valign="top"><td></td><td><?php _e( 'Message', 'imwb_zonpress' ); ?><br> <textarea name="imwb_zonpress_theme_options[newmembermailbody]" cols=60 rows=10><?php echo imwb_zonpress_get_option('newmembermailbody');?></textarea><div id="email-tags"><b>Tags:</b><br> {SITE_NAME} - <?php _e( 'The Blog/Site Name', 'imwb_zonpress' ); ?><br>{SITE_URL} - <?php _e( 'The Blog/Site URL', 'imwb_zonpress' ); ?><br>{USERNAME} - <?php _e( 'The members username', 'imwb_zonpress' ); ?><br>{PASSWORD} - <?php _e( 'The members password', 'imwb_zonpress' ); ?></div></td>
            	</tr>

            	<tr valign="top"><td width="350px"><?php _e( 'When new members register add them to autoresponder List.', 'imwb_zonpress' ); ?></td>
            	<td>
                  <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="N" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'N'  ? "checked='Yes'" : "" ?> />	<?php _e( 'No', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
                  <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="A" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'A'  ? "checked='Yes'" : "" ?> />	<?php _e( 'Aweber', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
                  <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="G" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'G'  ? "checked='Yes'" : "" ?> />	<?php _e( 'GetResponse', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
                   <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="I" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'I'  ? "checked='Yes'" : "" ?> />	<?php _e( 'iContact', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
                    <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="M" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'M'  ? "checked='Yes'" : "" ?> />	<?php _e( 'MailChimp', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
                    <input id="imwb_zonpress_theme_options[newmemberaroption]" type="radio" name="imwb_zonpress_theme_options[newmemberaroption]" value="O" <?php echo imwb_zonpress_get_option('newmemberaroption') == 'O'  ? "checked='Yes'" : "" ?> />	<?php _e( 'Other', 'imwb_zonpress' ); ?>&nbsp;&nbsp;
            	</td>
            	</tr>
               	<tr class="aweber-field <?php echo imwb_zonpress_get_option('newmemberaroption') != 'A' ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'Aweber authorization code:', 'imwb_zonpress' ); ?><br><a href="https://auth.aweber.com/1.0/oauth/authorize_app/919ff255" target="_blank"><?php _e( 'Click here to get your authorization code. ', 'imwb_zonpress' ); ?></a>
               	</td>
               	<td>
               	   <?php if(imwb_zonpress_get_option('aweber_auth_code') == '') { ?>  
               	    <input type="text" name="imwb_zonpress_theme_options[aweber_auth_code]" value="<?php echo esc_attr( imwb_zonpress_get_option('aweber_auth_code') ); ?>" size="60"/><br>
               	    <?php _e( 'Once you have got your authorization code and entered it above. You then need to save options in order to select the list to use. ', 'imwb_zonpress' ); ?>
               	   <?php } else { ?>
               	      <input type="hidden" name="imwb_zonpress_theme_options[aweber_auth_code]" value="<?php echo esc_attr( imwb_zonpress_get_option('aweber_auth_code') ); ?>" />
               	   <?php
               	      _e("You've successfully connected to your AWeber account!", 'imwb_zonpress' );
               	   ?>
               	      <input id="aweber-deauth" type="button" class="button-primary" value="<?php _e( 'Remove Connection', 'imwb_zonpress' ); ?>" />
               	   <?php } ?>
               	</td>
               	</tr>
               <?php if(imwb_zonpress_get_option('aweber_auth_code') != '')  { ?>
                  <tr class="aweber-field <?php echo imwb_zonpress_get_option('newmemberaroption') != 'A' ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'AWeber list to subscribe to', 'imwb_zonpress' ); ?>
                  </td>
                  <td>
               <?php
                  try {
                          $aweber = new AWeberAPI(imwb_zonpress_get_option('aweber_consumer_key'), imwb_zonpress_get_option('aweber_consumer_secret'));
                          $account = $aweber->getAccount(imwb_zonpress_get_option('aweber_access_key'), imwb_zonpress_get_option('aweber_access_secret'));
                      } catch (AWeberException $e) {
                          $error_ = get_class($e);
                          $account = null;
                      }
                      if(is_null($account)) {
                          _e( 'The following error occured when trying to connect to Aweber:', 'imwb_zonpress' );
                          echo ' '.$error_;                      
                      } else { 
                         $lists = $account->lists;
                      ?>
                       <select name="imwb_zonpress_theme_options[aweber_list]" id="imwb_zonpress_theme_options[aweber_list]">                 
                           <?php foreach ($lists as $this_list) { ?>
                              <option value="<?php echo $this_list->id; ?>"<?php echo ($this_list->id == imwb_zonpress_get_option('aweber_list')) ? ' selected="selected"' : ""; ?>><?php echo $this_list->name; ?></option>
                           <?php } ?>
                       </select>
                <?php } ?>
                  </td>
                  </tr>
               <?php } ?>
               <tr class="getresponse-field <?php echo imwb_zonpress_get_option('newmemberaroption') != 'G' ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'GetResponse API Key', 'imwb_zonpress' ); ?><br><small><?php _e( 'Get it from', 'imwb_zonpress' ); ?> <a href="https://app.getresponse.com/my_api_key.html" target="_blank"><?php _e( 'my account', 'imwb_zonpress' ); ?></a> <?php _e( 'section after logging to your GetResponse account.', 'imwb_zonpress' ); ?>
               </td>
               <td>
                   <input type="text" name="imwb_zonpress_theme_options[getresponse_api_key]" value="<?php echo esc_attr( imwb_zonpress_get_option('getresponse_api_key') ); ?>" size="60"/>
               </td>
               </tr>
               	<tr class="getresponse-field <?php echo imwb_zonpress_get_option('newmemberaroption') != 'G' ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'GetResponse Campaign to subscribe to', 'imwb_zonpress' ); ?>
               	</td>
               	<td>
       	             <?php if(imwb_zonpress_get_option('getresponse_api_key') != '') {
       	             # initialize JSON-RPC client
       	             $GR_client = new jsonRPCClient('http://api2.getresponse.com');
       	             try {
       	                $GR_campaigns = $GR_client->get_campaigns(imwb_zonpress_get_option('getresponse_api_key'));
       	             ?>
       	                <select id="imwb_zonpress_theme_options[getresponse_campaign]" class="regular-text" type="text" name="imwb_zonpress_theme_options[getresponse_campaign]" />
       	                <?php
       	                 foreach ($GR_campaigns as $campaign_id => $GR_campaign) {
       	                    $selected = (imwb_zonpress_get_option('getresponse_campaign') == $campaign_id) ? " selected" : "";
       	                    echo "<option value='{$campaign_id}' {$selected}>".$GR_campaign[name]."</option>";
       	                 }
       	                ?>
       	                </select>
                     <?php
       	             } catch (Exception $e) {
       	                echo 'GetResponse API Error: '.$e->getMessage();
       	             }
       	             ?>
            	        <?php } else { ?>
            	        <?php _e( 'You will need to enter your API Key then save options to gain access to the list of campaigns', 'imwb_zonpress' ); ?>
            	        <?php } ?>
               	</td>
               	</tr>
               	<tr class="arformurl-field <?php echo strpos('M', imwb_zonpress_get_option('newmemberaroption')) === false ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'HTML/Subscribe Form URL', 'imwb_zonpress' ); ?><br><b>OR</b>
               	</td>
               	<td><input type="text" id="imwb_zonpress_theme_options[ar_formurl]" class="regular-text" name="imwb_zonpress_theme_options[ar_formurl]" value="<?php echo imwb_zonpress_get_option('ar_formurl');?>" size="100">
               	</td>
               	</tr>
                   <tr class="arformoth-field <?php echo strpos('O', imwb_zonpress_get_option('newmemberaroption')) === false ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'Enter input field name for the email input', 'imwb_zonpress' ); ?>
                   </td>
                   <td><input type="text" id="imwb_zonpress_theme_options[ar_formfldemail]" class="regular-text" name="imwb_zonpress_theme_options[ar_formfldemail]" value="<?php echo imwb_zonpress_get_option('ar_formfldemail');?>" size="100">
                   </td>
                   </tr>              	
                   <tr class="arformoth-field <?php echo strpos('O', imwb_zonpress_get_option('newmemberaroption')) === false ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'Enter input field name for the name input', 'imwb_zonpress' ); ?>
                   </td>
                   <td><input type="text" id="imwb_zonpress_theme_options[ar_formfldname]" class="regular-text" name="imwb_zonpress_theme_options[ar_formfldname]" value="<?php echo imwb_zonpress_get_option('ar_formfldname');?>" size="100">
                   </td>
                   </tr>                	
               	 <tr class="arform-field <?php echo strpos('IMO', imwb_zonpress_get_option('newmemberaroption')) === false ? 'hidden' : '';?>" valign="top"><td width="350px"><?php _e( 'HTML Sign-up form', 'imwb_zonpress' ); ?>
               	 </td>
               	 <td><textarea id="imwb_zonpress_theme_options[ar_form]" class="regular-text" name="imwb_zonpress_theme_options[ar_form]" cols=60 rows=10><?php echo imwb_zonpress_get_option('ar_form');?></textarea>
               	</td>
               	</tr>
               </tbody>
            	</table>

            	<br>
            	<table class="widefat">
            	 <thead>
            	  <tr>
            	   <th scope="col"><?php _e( 'Additional Header Scripts/Styles', 'imwb_zonpress' ); ?></th>
            	  </tr>
            	 </thead>
            	  <tbody style="display: table-row-group;">

            	<tr valign="top"><td><?php _e( 'Use this section to place additional scripts and/or CSS styles into the <head> section of the theme. Whatever you put here is placed exactly into the code, so be careful with the syntax as it could adversely effect your site.', 'imwb_zonpress' ); ?><br><textarea name="imwb_zonpress_theme_options[headerscripts]" style="width:100%;" rows=10><?php echo imwb_zonpress_get_option('headerscripts');?></textarea></td>
            	</tr>
            	</tbody>
            	</table>
            	
            	<br>
            	<table class="widefat">
            	 <thead>
            	  <tr>
            	   <th scope="col"><?php _e( 'Additional Home Page Scripts/HTML/Text', 'imwb_zonpress' ); ?></th>
            	  </tr>
            	 </thead>
            	  <tbody style="display: table-row-group;">

            	<tr valign="top"><td><?php _e( 'Use this section to place additional scripts and/or HTML/Text that will go on the home page after the page navigation. Whatever you put here is placed exactly into the page, so be careful with the syntax as it could adversely effect your site.', 'imwb_zonpress' ); ?><br><textarea name="imwb_zonpress_theme_options[homepagescripts]" style="width:100%;" rows=10><?php echo imwb_zonpress_get_option('homepagescripts');?></textarea></td>
            	</tr>
            	</tbody>
            	</table>
			<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'imwb_zonpress' ); ?>" />
			</p>
		</form>

		</div>
  </div>
	<?php
}

/**
 * Create the options page
 */
function imwb_zonpress_theme_export_do_page() {
   global $sidebar_options, $yesno_options, $listorder_options;

	?>

	<div class="wrap">
	<div id="imwb_plugin_header">
	<a href="http://imwealthbuilders.com" target="_blank"><img src="<?php echo get_template_directory_uri(). '/images/imwblogo.png';?>"></a>
	<span id="imwb_plugin_header_link"><a href="http://imwealthbuilders.com/newplugins" target="_blank">Click Here To See Our Latest WP Plugins</a></span>
	<h2>Covert Store Builder Theme</h2>
	<div style="clear: both"></div>
	</div>
	<div id="imwb_plugin_options_editor">

		<?php screen_icon(); echo "<h2>" . __( 'Export Leads', 'imwb_zonpress' ) . ' - <small><a href="http://covertstorebuilder.com/help/std_help.html#export" target="_blank">Click Here For Help</a></small></h2>'; ?>

		<form method="post" action="" enctype="multipart/form-data">
		<?php settings_fields( 'imwb_zonpress_options' ); ?>
		<table class="form-table">
		<tr valign="top">
			<th scope="row"><label><?php _e( 'Date range', 'export-users-to-csv' ); ?></label></th>
			<td>
				<select name="start_date" id="pp_eu_users_start_date">
					<option value="0"><?php _e( 'Start Date', 'export-users-to-csv' ); ?></option>
					<?php imwb_zonpress_theme_date_options(); ?>
				</select>
				<select name="end_date" id="pp_eu_users_end_date">
					<option value="0"><?php _e( 'End Date', 'export-users-to-csv' ); ?></option>
					<?php imwb_zonpress_theme_date_options(); ?>
				</select>
			</td>
		</tr>
		</table>
		<p class="submit">
			<input type="hidden" name="_wp_http_referer" value="<?php echo $_SERVER['REQUEST_URI'] ?>" />
			<input type="submit" class="button-primary" value="<?php _e( 'Export', 'export-users-to-csv' ); ?>" />
		</p>
			</form>
		</form>
		</div>
		</div>

<?php

}

function imwb_zonpress_theme_date_options() {
		global $wpdb, $wp_locale;

		$months = $wpdb->get_results( "
			SELECT DISTINCT YEAR( user_registered ) AS year, MONTH( user_registered ) AS month
			FROM $wpdb->users
			ORDER BY user_registered DESC
		" );

		$month_count = count( $months );
		if ( !$month_count || ( 1 == $month_count && 0 == $months[0]->month ) )
			return;

		foreach ( $months as $date ) {
			if ( 0 == $date->year )
				continue;

			$month = zeroise( $date->month, 2 );
			echo '<option value="' . $date->year . '-' . $month . '">' . $wp_locale->get_month( $month ) . ' ' . $date->year . '</option>';
		}
	}

	function imwb_zonpress_theme_export_user_query( $user_search ) {
			global $wpdb;

			$where = '';

			if ( ! empty( $_REQUEST['start_date'] ) )
				$where .= $wpdb->prepare( " AND $wpdb->users.user_registered >= %s", date( 'Y-m-d', strtotime( $_REQUEST['start_date'] ) ) );

			if ( ! empty( $_REQUEST['end_date'] ) )
				$where .= $wpdb->prepare( " AND $wpdb->users.user_registered < %s", date( 'Y-m-d', strtotime( '+1 month', strtotime( $_REQUEST['end_date'] ) ) ) );

			if ( ! empty( $where ) )
				$user_search->query_where = str_replace( 'WHERE 1=1', "WHERE 1=1$where", $user_search->query_where );

			return $user_search;
		}

/**
 * Sanitize and validate input. Accepts an array, return a sanitized array.
 */

function imwb_zonpress_theme_options_validate( $input ) {
   $output = imwb_zonpress_get_default_theme_options();
   $output['shareoptions'] = '';

   foreach ($input as $key => $value) {
      if($key == "postchars")
         $input[$key] = is_numeric($value) ? $value : 100;
      else if($key == "excludecats")
         $input[$key] = implode(',', $value);
      else if($key == "fpexcludecats")
         $input[$key] = implode(',', $value);
      else if($key == "includecats")
         $input[$key] = implode(',', $value);
      else if($key == "shareoptions")
         $input[$key] = implode(',', $value);
      else if($key == "wlshareoptions")
         $input[$key] = implode(',', $value);
      else if($key == "hpexcludecats")
         $input[$key] = implode(',', $value);         

		$output[$key] = trim($input[$key]);
	}
	
	$output['aweber_consumer_key'] = imwb_zonpress_get_option('aweber_consumer_key');
	$output['aweber_consumer_secret'] = imwb_zonpress_get_option('aweber_consumer_secret');
	$output['aweber_access_key'] = imwb_zonpress_get_option('aweber_access_key');
	$output['aweber_access_secret'] = imwb_zonpress_get_option('aweber_access_secret');

  	return $output;
 }


// See if were saving theme options
if(isset($_REQUEST['page']) && $_REQUEST['page'] == 'imwb_zonpress_theme_options' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'update') {

   // Deal with file uploads
   // favicon
   if ((($_FILES["favicon_img"]["type"] == "image/gif")
      || ($_FILES["favicon_img"]["type"] == "image/jpeg")
      || ($_FILES["favicon_img"]["type"] == "image/png")
      || ($_FILES["favicon_img"]["type"] == "image/jpeg")
      || ($_FILES["favicon_img"]["type"] == "image/pjpeg")
      || ($_FILES["favicon_img"]["type"] == "image/x-icon"))
      && ($_FILES["favicon_img"]["size"] > 0) &&  ($_FILES["favicon_img"]["error"] == 0))
   {
   	  $path = wp_upload_dir();
   	  if( !file_exists(  $path['path'] ) )
   	  {
   			mkdir(  $path['path'] );
   	  }
   	  $logopath=  $path['path'] . "/" . $_FILES["favicon_img"]["name"];
   	  if( file_exists(  $logopath ) )
   	  {
   			unlink( $logopath);
   	  }

        move_uploaded_file( $_FILES["favicon_img"]["tmp_name"],  $logopath);
   	  $_REQUEST['imwb_zonpress_theme_options']['faviconurl'] =  $path['url'] . "/" . $_FILES["favicon_img"]["name"] ;
   }

   if ((($_FILES["file_defOGPImg"]["type"] == "image/gif")
      || ($_FILES["file_defOGPImg"]["type"] == "image/jpeg")
      || ($_FILES["file_defOGPImg"]["type"] == "image/png")
      || ($_FILES["file_defOGPImg"]["type"] == "image/jpeg")
      || ($_FILES["file_defOGPImg"]["type"] == "image/pjpeg")
      || ($_FILES["file_defOGPImg"]["type"] == "image/x-icon"))
      && ($_FILES["file_defOGPImg"]["size"] > 0) &&  ($_FILES["file_defOGPImg"]["error"] == 0))
   {
   	  $path = wp_upload_dir();
   	  if( !file_exists(  $path['path'] ) )
   	  {
   			mkdir(  $path['path'] );
   	  }
   	  $logopath=  $path['path'] . "/" . $_FILES["file_defOGPImg"]["name"];
   	  if( file_exists(  $logopath ) )
   	  {
   			unlink( $logopath);
   	  }

        move_uploaded_file( $_FILES["file_defOGPImg"]["tmp_name"],  $logopath);
   	  $_REQUEST['imwb_zonpress_theme_options']['defOGPImg'] =  $path['url'] . "/" . $_FILES["file_defOGPImg"]["name"] ;
   }

   if ((($_FILES["custdefault_img"]["type"] == "image/gif")
      || ($_FILES["custdefault_img"]["type"] == "image/jpeg")
      || ($_FILES["custdefault_img"]["type"] == "image/png")
      || ($_FILES["custdefault_img"]["type"] == "image/jpeg")
      || ($_FILES["custdefault_img"]["type"] == "image/pjpeg")
      || ($_FILES["custdefault_img"]["type"] == "image/x-icon"))
      && ($_FILES["custdefault_img"]["size"] > 0) &&  ($_FILES["custdefault_img"]["error"] == 0))
   {
   	  $path = wp_upload_dir();
   	  if( !file_exists(  $path['path'] ) )
   	  {
   			mkdir(  $path['path'] );
   	  }
   	  $logopath=  $path['path'] . "/" . $_FILES["custdefault_img"]["name"];
   	  if( file_exists(  $logopath ) )
   	  {
   			unlink( $logopath);
   	  }

       move_uploaded_file( $_FILES["custdefault_img"]["tmp_name"],  $logopath);
   	  $_REQUEST['imwb_zonpress_theme_options']['custdefaultimg'] =  $path['url'] . "/" . $_FILES["custdefault_img"]["name"] ;
   }

   // Save options
   $updatedOptions = imwb_zonpress_theme_options_validate($_REQUEST['imwb_zonpress_theme_options']);
   
   if(isset($_REQUEST['aweber-auth']) && $_REQUEST['aweber-auth'] == 'deauth') {
      $updatedOptions['aweber_auth_code'] = "";
      $updatedOptions['aweber_consumer_key'] = "";
      $updatedOptions['aweber_consumer_secret'] = "";
      $updatedOptions['aweber_access_key'] = "";
      $updatedOptions['aweber_access_secret'] = "";
      $updatedOptions['aweber_list'] = "";
   
   } else if($updatedOptions['aweber_auth_code'] != '' && $updatedOptions['aweber_consumer_key'] == '' && imwb_zonpress_get_option('aweber_consumer_secret')    == '') {

      try {
         list($consumer_key, $consumer_secret, $access_key, $access_secret) = AWeberAPI::getDataFromAweberID($updatedOptions['aweber_auth_code']);
      } catch (AWeberAPIException $exc) {
          list($consumer_key, $consumer_secret, $access_key, $access_secret) = null;
          $updatedOptions['aweber_auth_code'] = '';
          # make error messages customer friendly.
          $descr = $exc->description;
          $descr = preg_replace('/http.*$/i', '', $descr);     # strip labs.aweber.com documentation url from error message
          $descr = preg_replace('/[\.\!:]+.*$/i', '', $descr); # strip anything following a . : or ! character
          $aweber_error_code = " ($descr)";
      } catch (AWeberOAuthDataMissing $exc) {
         $updatedOptions['aweber_auth_code'] = '';
          list($consumer_key, $consumer_secret, $access_key, $access_secret) = null;
      } catch (AWeberException $exc) {
         $updatedOptions['aweber_auth_code'] = '';
          list($consumer_key, $consumer_secret, $access_key, $access_secret) = null;
      }
      
      $updatedOptions['aweber_consumer_key'] = $consumer_key;
      $updatedOptions['aweber_consumer_secret'] =$consumer_secret;
      $updatedOptions['aweber_access_key'] = $access_key;
      $updatedOptions['aweber_access_secret'] = $access_secret;
   }
 
   if($updatedOptions['newmemberaroption'] == 'I' || $updatedOptions['newmemberaroption'] == 'M' || $updatedOptions['newmemberaroption'] == 'O') {
   
      $new_ar['error'] = '';
      
      if(($updatedOptions['newmemberaroption'] == 'M')
          && $updatedOptions['ar_formurl'] != "") {
         $response = wp_remote_get(urldecode($updatedOptions['ar_formurl']));
         if( is_wp_error( $response ) ) 
            $new_ar['error'] = $response->get_error_message();
         
         $parser = new HtmlFormParser( urldecode($response['body']) );
      }
      else 
         $parser = new HtmlFormParser( urldecode(stripslashes($updatedOptions['ar_form'])) );
         
   	$result = $parser->parseForms();
   	$result = $result[0];
   	
      if($updatedOptions['newmemberaroption'] == 'I') {   	
      	$new_ar['name'] = 'icontact';
    		$new_ar['action'] = $result['form_data']['action'];
      	foreach ($result['form_elemets'] as $key => $value) {
            if($key == 'fields_fname') $new_ar['form_data'][$key] = '%%FNAME%%';
            else if($key == 'fields_lname') $new_ar['form_data'][$key] = '%%LNAME%%';
            else if($key == 'fields_email') $new_ar['form_data'][$key] = '%%EMAIL%%';
            else $new_ar['form_data'][$key] = $value['value'];
      	}
         foreach ($result['buttons'] as $key => $value) {
            if($value['type'] == 'submit') $new_ar['form_data'][$value['type']] = $value['value'];
         }	
      }
      else if($updatedOptions['newmemberaroption'] == 'M') {   	
      	$new_ar['name'] = 'mailchimp';
      	$new_ar['action'] = $result['form_data']['action'];
      	foreach ($result['form_elemets'] as $key => $value) {
            if($key == 'EMAIL')	$new_ar['form_data'][$key] = '%%EMAIL%%';
            else if($key == 'MERGE0') $new_ar['form_data'][$key] = '%%EMAIL%%';
            else if($key == 'MERGE1') $new_ar['form_data'][$key] = '%%FNAME%%';
            else if($key == 'MERGE2') $new_ar['form_data'][$key] = '%%LNAME%%';
            else $new_ar['form_data'][$key] = $value['value'];
      	}
         foreach ($result['buttons'] as $key => $value) {
            if($value['type'] == 'submit') $new_ar['form_data'][$value['type']] = $value['value'];
         }	
      }
      else if($updatedOptions['newmemberaroption'] == 'O') {   	
      	$new_ar['name'] = 'otherar';
      	$new_ar['action'] = $result['form_data']['action'];
      	foreach ($result['form_elemets'] as $key => $value) {
           if($key == $updatedOptions['ar_formfldemail']) $new_ar['form_data'][$key] = '%%EMAIL%%';
           else if($key == $updatedOptions['ar_formfldname']) $new_ar['form_data'][$key] = '%%NAME%%';
           else $new_ar['form_data'][$key] = $value['value'];
      	}
         foreach ($result['buttons'] as $key => $value) {
            if($value['type'] == 'submit') $new_ar['form_data'][$value['type']] = $value['value'];
         }	
      }

   	update_option('imwb_zonpress_theme_ar_data', $new_ar);
   }

   if(isset($_REQUEST['color-scheme']) && !empty($_REQUEST['color-scheme'])) {
      if($_REQUEST['color-scheme'] == 'scheme-white') {
         set_theme_mod('header_textcolor', '000000' );
         set_theme_mod('background_color', 'FFFFFF' );
         $updatedOptions['headerbgcol'] = '#FFFFFF';
         $updatedOptions['sitemenutxtcol'] = '#606060';
         $updatedOptions['menutxtcol'] = '#606060';
         $updatedOptions['menuseltxtcol'] = '#000000';
         $updatedOptions['menubgcol'] = '#FFFFFF';
         $updatedOptions['postmenutxtcol'] = '#606060';
         $updatedOptions['postmenuseltxtcol'] = '#0088CC';
         $updatedOptions['postmenubgcol'] = '#FFFFFF';
         $updatedOptions['sidebarbgcol'] = '#FFFFFF';
         $updatedOptions['widgettitlebgcol'] = '#C6C6C6';
         $updatedOptions['widgettitletxtcol'] = '#040404';
         $updatedOptions['fpbgcol'] = '#FFFFFF';
  	      $updatedOptions['fpbdrcol'] = '#FFFFFF';
  	      $updatedOptions['fptitlecol'] = '#0088CC';
  	      $updatedOptions['fptitlehvrcol'] = '#005580';
  	      $updatedOptions['fpdesccol'] = '#606060';
  	      $updatedOptions['postbgcol'] = '#FFFFFF';
  	      $updatedOptions['posttitlecol'] = '#606060';
  	      $updatedOptions['posttitlehvrcol'] = '#005580';
  	      $updatedOptions['postdesccol'] = '#606060';
  	      $updatedOptions['fppricecol'] = '#347C17';
  	      $updatedOptions['postprdbtntxtcol'] = '#FFFFFF';
  	      $updatedOptions['postprdbtnbgcol'] = '#5BB75B';
  	      $updatedOptions['postprdbtnbghvrcol'] = '#51A351';
  	      $updatedOptions['footerbgcol'] = '#606060';
  	      $updatedOptions['footertxtcol'] = '#DDDDDD';
      }
      else if($_REQUEST['color-scheme'] == 'scheme-coffee') {
         set_theme_mod('background_color', '665743' );
         set_theme_mod('header_textcolor', '000000' );

         $updatedOptions['headerbgcol'] = '#f5f4bc';
         $updatedOptions['sitemenutxtcol'] = '#483f32';
         $updatedOptions['menutxtcol'] = '#483f32';
         $updatedOptions['menuseltxtcol'] = '#000000';
         $updatedOptions['menubgcol'] = '#c14e27';
         $updatedOptions['postmenutxtcol'] = '#c14e27';
         $updatedOptions['postmenuseltxtcol'] = '#7c9f3e';
         $updatedOptions['postmenubgcol'] = '#f5f4bc';
         $updatedOptions['sidebarbgcol'] = '#fcfcde';
         $updatedOptions['widgettitlebgcol'] = '#c14e27';
         $updatedOptions['widgettitletxtcol'] = '#040404';
         $updatedOptions['fpbgcol'] = '#fcfcde';
         $updatedOptions['fpbdrcol'] = '#fcfcde';
         $updatedOptions['fptitlecol'] = '#c14e27';
         $updatedOptions['fptitlehvrcol'] = '#a03a18';
         $updatedOptions['fpdesccol'] = '#665743';
         $updatedOptions['postbgcol'] = '#f5f4bc';
         $updatedOptions['posttitlecol'] = '#665743';
         $updatedOptions['posttitlehvrcol'] = '#a03a18';
         $updatedOptions['postdesccol'] = '#606060';
         $updatedOptions['fppricecol'] = '#7c9f3e';
         $updatedOptions['postprdbtntxtcol'] = '#FFFFFF';
         $updatedOptions['postprdbtnbgcol'] = '#c14e27';
         $updatedOptions['postprdbtnbghvrcol'] = '#a03a18';
         $updatedOptions['footerbgcol'] = '#c14e27';
         $updatedOptions['footertxtcol'] = '#f5f4bc';
         
      }
      else if($_REQUEST['color-scheme'] == 'scheme-fairy') {
         set_theme_mod('background_color', 'f79c89' );
         set_theme_mod('header_textcolor', '000000' );
         
         $updatedOptions['headerbgcol'] = '#ffe3a3';
         $updatedOptions['sitemenutxtcol'] = '#432f04';
         $updatedOptions['menutxtcol'] = '#432f04';
         $updatedOptions['menuseltxtcol'] = '#000000';
         $updatedOptions['menubgcol'] = '#7c9f3e';
         $updatedOptions['postmenutxtcol'] = '#432f04';
         $updatedOptions['postmenuseltxtcol'] = '#ffe3a3';
         $updatedOptions['postmenubgcol'] = '#7c9f3e';
         $updatedOptions['sidebarbgcol'] = '#fcfcde';
         $updatedOptions['widgettitlebgcol'] = '#c14e27';
         $updatedOptions['widgettitletxtcol'] = '#ffffff';
         $updatedOptions['fpbgcol'] = '#fcfcde';
         $updatedOptions['fpbdrcol'] = '#fcfcde';
         $updatedOptions['fptitlecol'] = '#c14e27';
         $updatedOptions['fptitlehvrcol'] = '#a03a18';
         $updatedOptions['fpdesccol'] = '#665743';
         $updatedOptions['postbgcol'] = '#fbfbee';
         $updatedOptions['posttitlecol'] = '#432f04';
         $updatedOptions['posttitlehvrcol'] = '#f79c89';
         $updatedOptions['postdesccol'] = '#606060';
         $updatedOptions['fppricecol'] = '#7c9f3e';
         $updatedOptions['postprdbtntxtcol'] = '#FFFFFF';
         $updatedOptions['postprdbtnbgcol'] = '#f04f2d';
         $updatedOptions['postprdbtnbghvrcol'] = '#d92c08';
         $updatedOptions['footerbgcol'] = '#ffe3a3';
         $updatedOptions['footertxtcol'] = '#f5f4bc';
            
         }
      else if($_REQUEST['color-scheme'] == 'scheme-blue') {
         set_theme_mod('background_color', '7fa7b8' );
         set_theme_mod('header_textcolor', '000000' );
         
         $updatedOptions['headerbgcol'] = '#a3bbc2';
         $updatedOptions['sitemenutxtcol'] = '#e8f3f8';
         $updatedOptions['menutxtcol'] = '#e8f3f8';
         $updatedOptions['menuseltxtcol'] = '#ffffff';
         $updatedOptions['menubgcol'] = '#7c9f3e';
         $updatedOptions['postmenutxtcol'] = '#432f04';
         $updatedOptions['postmenuseltxtcol'] = '#ffffff';
         $updatedOptions['postmenubgcol'] = '#7fa7b8';
         $updatedOptions['sidebarbgcol'] = '#ffffff';
         $updatedOptions['widgettitlebgcol'] = '#f7f7f7';
         $updatedOptions['widgettitletxtcol'] = '#20627e';
         $updatedOptions['fpbgcol'] = '#ffffff';
         $updatedOptions['fpbdrcol'] = '#ffffff';
         $updatedOptions['fptitlecol'] = '#20627e';
         $updatedOptions['fptitlehvrcol'] = '#a03a18';
         $updatedOptions['fpdesccol'] = '#7fa7b8';
         $updatedOptions['postbgcol'] = '#f7f7f7';
         $updatedOptions['posttitlecol'] = '#20627e';
         $updatedOptions['posttitlehvrcol'] = '#1778a1';
         $updatedOptions['postdesccol'] = '#a6a6a6';
         $updatedOptions['fppricecol'] = '#20627e';
         $updatedOptions['postprdbtntxtcol'] = '#FFFFFF';
         $updatedOptions['postprdbtnbgcol'] = '#628523';
         $updatedOptions['postprdbtnbghvrcol'] = '#496812';
         $updatedOptions['footerbgcol'] = '#a3bbc2';
         $updatedOptions['footertxtcol'] = '#f5f4bc';
            
         }
      else if($_REQUEST['color-scheme'] == 'scheme-red') {
         set_theme_mod('background_color', '7e0000' );
         set_theme_mod('header_textcolor', 'ffffff' );
         
         $updatedOptions['headerbgcol'] = '#9f0000';
         $updatedOptions['sitemenutxtcol'] = '#f8e8e9';
         $updatedOptions['menutxtcol'] = '#f8e8e9';
         $updatedOptions['menuseltxtcol'] = '#ffffff';
         $updatedOptions['menubgcol'] = '#610000';
         $updatedOptions['postmenutxtcol'] = '#f8e8e9';
         $updatedOptions['postmenuseltxtcol'] = '#ffffff';
         $updatedOptions['postmenubgcol'] = '#610000';
         $updatedOptions['sidebarbgcol'] = '#ffffff';
         $updatedOptions['widgettitlebgcol'] = '#f7f7f7';
         $updatedOptions['widgettitletxtcol'] = '#610000';
         $updatedOptions['fpbgcol'] = '#ffffff';
         $updatedOptions['fpbdrcol'] = '#ffffff';
         $updatedOptions['fptitlecol'] = '#9f0000';
         $updatedOptions['fptitlehvrcol'] = '#a03a18';
         $updatedOptions['fpdesccol'] = '#430000';
         $updatedOptions['postbgcol'] = '#f7f7f7';
         $updatedOptions['posttitlecol'] = '#610000';
         $updatedOptions['posttitlehvrcol'] = '#a03a18';
         $updatedOptions['postdesccol'] = '#430000';
         $updatedOptions['fppricecol'] = '#7e0000';
         $updatedOptions['postprdbtntxtcol'] = '#FFFFFF';
         $updatedOptions['postprdbtnbgcol'] = '#628523';
         $updatedOptions['postprdbtnbghvrcol'] = '#496812';
         $updatedOptions['footerbgcol'] = '#7e0000';
         $updatedOptions['footertxtcol'] = '#ffffff';
            
         }
   
   }

   update_option('imwb_zonpress_theme_options', $updatedOptions);

}
// Or exporting Users
else if(isset($_REQUEST['page']) && $_REQUEST['page'] == 'imwb_zonpress_theme_export_users' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'update') {

   $args = array(
   	'fields' => 'all_with_meta',
   	'role' => 'subscriber' );

   add_action( 'pre_user_query', 'imwb_zonpress_theme_export_user_query' );
   $users = get_users( $args );
   remove_action( 'pre_user_query', 'imwb_zonpress_theme_export_user_query' );

   if ( $users ) {

      $sitename = sanitize_key( get_bloginfo( 'name' ) );
      if ( ! empty( $sitename ) )
      	$sitename .= '-';
      $filename = $sitename . 'leads.' . date( 'Y-m-d-H-i-s' ) . '.csv';

      header( 'Content-Description: File Transfer' );
      header( 'Content-Disposition: attachment; filename=' . $filename );
      header( 'Content-Type: text/csv; charset=' . get_option( 'blog_charset' ), true );

      $exclude_data = array( 'user_pass', 'user_activation_key' );

      global $wpdb;

      $data_keys = array(
      	'ID', 'user_login', 'user_pass',
      	'user_nicename', 'user_email', 'user_url',
      	'user_registered', 'user_activation_key', 'user_status',
      	'display_name'
      );
      $meta_keys = $wpdb->get_results( "SELECT distinct(meta_key) FROM $wpdb->usermeta" );
      $meta_keys = wp_list_pluck( $meta_keys, 'meta_key' );
      $fields = array_merge( $data_keys, $meta_keys );

      echo '"ID","Username","Firstname","Lastname","Email","Date_Registered"'."\n";

      foreach ( $users as $user ) {
         $data = array();
         $data[] = '"' . str_replace( '"', '""', $user->ID ) . '"';
         $data[] = '"' . str_replace( '"', '""', $user->user_login ) . '"';
         $data[] = '"' . str_replace( '"', '""', $user->first_name ) . '"';
         $data[] = '"' . str_replace( '"', '""', $user->last_name ) . '"';
         $data[] = '"' . str_replace( '"', '""', $user->user_email ) . '"';
         $data[] = '"' . str_replace( '"', '""', $user->user_registered ) . '"';
      	echo implode( ',', $data ) . "\n";
      }

      exit;
   }
}

?>