
;(function( $, window, document, undefined )
{
	$.fn.doubleTapToGo = function( params )
	{
		if( !( 'ontouchstart' in window ) &&
			!navigator.msMaxTouchPoints &&
			!navigator.userAgent.toLowerCase().match( /windows phone os 7/i ) ) return false;

		this.each( function()
		{
			var curItem = false;

			$( this ).on( 'click', function( e )
			{
				var item = $( this );
				if( item[ 0 ] != curItem[ 0 ] )
				{
					e.preventDefault();
					curItem = item;
				}
			});

			$( document ).on( 'click touchstart MSPointerDown', function( e )
			{
				var resetItem = true,
					parents	  = $( e.target ).parents();

				for( var i = 0; i < parents.length; i++ )
					if( parents[ i ] == curItem[ 0 ] )
						resetItem = false;

				if( resetItem )
					curItem = false;
			});
		});
		return this;
	};
})( jQuery, window, document );

/*
 * SimpleModal 
 * Modified from the Wordpress plugin to handle login and register forms for Covert Store Builder
 * Copyright (c) 2012 Eric Martin http://www.ericmmartin.com
*/
jQuery(function ($) {
   var SimpleModalLogin = {   
      init: function () {
         var s = this;
         s.error = [];
         $('.smcf-login, .smcf-register, .smcf-forgotpw').on('click.simplemodal', function (e) {
            s.login = $('#loginform'),
            s.lostpw = $('#lostpasswordform'),
            s.register = $('#registerform');
            if ($(this).hasClass('smcf-login')) {   
               s.form = '#loginform';
               s.login.show(); s.lostpw.hide(); s.register.hide();
            }
            else if ($(this).hasClass('smcf-register')) {
               s.form = '#registerform';
               s.register.show(); s.login.hide(); s.lostpw.hide();
            }
            else {
               s.form = '#lostpasswordform';
               s.lostpw.show(); s.login.hide(); s.register.hide();
            }
            s.url = this.href;
            if (!$('#smcf-container').length) {
               $('#smcf-login-form').modal({
                        overlayId: 'smcf-overlay',
                        containerId: 'smcf-container',
                        opacity:85,
                        onShow: SimpleModalLogin.show,
                        position: ['15%', null],
                        zIndex:10000
               });
            }
            else {
               SimpleModalLogin.show();
            }
            return false;
         });
      },
      show: function (obj) {
         var s = SimpleModalLogin;
         s.dialog = obj || s.dialog;
         s.modal = s.modal || this;
         var form = $(s.form, s.dialog.data[0]),
         fields = $('.smcf-login-fields', form[0]),
         activity = $('.smcf-activity', form[0]);
         // update and focus dialog
         s.dialog.container.css({height:'auto'});
         // remove any existing errors or messages
         s.clear(s.dialog.container[0]);
         form.unbind('submit.simplemodal').bind('submit.simplemodal', function (e) {
            e.preventDefault();
            // remove any existing errors or messages
            s.clear(s.dialog.container[0]);
            if (s.isValid(form)) {
               fields.hide(); activity.show();
               if (s.url && s.url.indexOf('redirect_to') !== -1) {
                  var p = s.url.split('=');
                  form.append($('<input type="hidden" name="redirect_to">').val(unescape(p[1])));
               }
               $.ajax({
                  url: form[0].action,
                  data: form.serialize(),
                  type: 'POST',
                  cache: false,
                  success: function (resp) {
                     var data = $(document.createElement('div')).html(resp),
                     redirect = $('#smcf-login-redirect', data[0]);
                     if (redirect.length) {
                        var href = location.href;
                        if (redirect.html().length) {
                           href = redirect.html();
                        }
                        window.location = href;
                     }
                     else {
                        var error = $('#login_error', data[0]),
                        message = $('.message', data[0]),
                        loginform = $(s.form, data[0]);
                        if (error.length) {
                           error.find('a').addClass('smcf-forgotpw');
                           $('p:first', form[0]).before(error);
                           activity.hide(); fields.show();
                        }
                        else if (message.length) {
                           if (s.form === '#lostpasswordform' || s.form === '#registerform') {
                              s.form = '#loginform';
                              s.lostpw.hide(); s.register.hide();
                              s.login.show();
                              SimpleModalLogin.show();
                           }
                           $('p:first', form[0]).before(message);
                           activity.hide(); fields.show();
                        }
                        else if (loginform.length) {
                           s.showError(form, ['empty_all']);
                           activity.hide(); fields.show();
                        }
                     }
                  },
                  error: function (xhr) {
                     $('p:first', form[0]).before(
                        $(document.createElement('div')).html('<strong>ERROR</strong>: ' + xhr.statusText).attr('id', 'login_error'));
                     activity.hide(); fields.show();
                  }
               });
            }
            else {
               s.showError(form, s.error);
            }
         });
      },
      /* utility functions */
      clear: function (context) {
         $('#login_error, .message', context).remove();
      },
      isValid: function (form) {
         var log = $('.user_login', form[0]),
         pass = $('.user_pass', form[0]),
         email = $('.user_email', form[0]),
         firstname = $('.firstname', form[0]),
         lastname = $('.lastname', form[0]),
         fields = $(':text, :password', form[0]),
         valid = true;
         SimpleModalLogin.error = [];
         if (firstname.length && !$.trim(firstname.val())) {
            SimpleModalLogin.error.push('empty_firstname');
            valid = false;
         }
         else if (lastname.length && !$.trim(lastname.val())) {
            SimpleModalLogin.error.push('empty_lastname');
            valid = false;
         }
         else if (log.length && !$.trim(log.val())) {
            SimpleModalLogin.error.push('empty_username');
            valid = false;
         }
         else if (email.length && !$.trim(email.val())) {
            SimpleModalLogin.error.push('empty_email');
            valid = false;
         }
         else if (pass.length && !$.trim(pass.val())) {
            SimpleModalLogin.error.push('empty_password');
            valid = false;
         }
         var empty_count = 0;
         fields.each(function () {
            if (!$.trim(this.value)) {
               empty_count++;
            }
         });
         if (fields.length > 1 && empty_count === fields.length) {
            SimpleModalLogin.error = ['empty_all'];
            valid = false;
         }
         return valid;
      },
      message: function (key) {
         return SimpleModalLoginL10n[key] ? SimpleModalLoginL10n[key] :  key;
      },
      showError: function (form, keys) {
         keys = $.map(keys, function (key) {
            return SimpleModalLogin.message(key);
         });
      
         $('p:first', form[0]).before($('<div id="login_error"></div>').html(keys.join('<br>')));
      }
   };
   SimpleModalLogin.init(); 
});

jQuery(document).ready(function($) {
   
   $('.carousel').carousel({interval: SimpleModalLoginL10n['carousel-interval']});
   $( '#page-navigation li:has(ul)' ).doubleTapToGo();
   
   $('#mainCarousel').on('slide', function (event) { 
      var postId = $(event.relatedTarget).attr('data-post-item');
      $('.carousel-thumbs a.active').removeClass('active');
      $('.carousel-thumbs a[data-post-item="'+postId+'"]').addClass('active');
   });
   
   $('.carousel-thumbs li > a').click(function(event) {
      var frame = $(this).attr('href').slice( 1 );
      $('#mainCarousel').carousel(parseInt(frame));
      event.preventDefault();
   });
   
});

function imwb_zonpress_window_open(href, url) {
   href = href.replace(/{URL}/, encodeURIComponent(url))
   window.open(href, 'popUp', 'width=620,height=440');
}
