<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if gt IE 8]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->
<head>
<title><?php imwb_zonpress_get_blogtitle(); ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php 
   $favicon = imwb_zonpress_get_option('faviconurl');
   if(empty($favicon)) 
      echo '<link rel="Shortcut Icon" href="'.get_template_directory_uri().'/images/favicon.ico" type="image/x-icon">';
   else
      echo '<link rel="Shortcut Icon" href="'.$favicon.'" type="image/x-icon">';
?>	
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php wp_head(); ?>
<script>
   jQuery(document).ready(function($) {
   
   $('a.zp-ctr-track, .zp-product .moretag').click(function(event) {
      var btn = this;
      var data = { action :'update_ctr_action', postid: $(btn).attr('data-post-item'), nonce : '<?php echo wp_create_nonce( "imwb_zonpress_update_ctr" );?>'};
         
      $.ajax({async: false, type: 'POST', url: '<?php echo admin_url( "admin-ajax.php" );?>',
         data: data,  dataType: 'json'});
   });

<?php if (is_user_logged_in()) { ?>
      $('a.wishlistlink').click(function(event) {
         var btn = this;
         var data = { action :'update_wishlist_action', postid: $(btn).attr('data-post-item'),
             userid: <?php echo $user_ID; ?>, nonce : '<?php echo wp_create_nonce( "imwb_zonpress_update_wishlist" );?>'
         };
            
         $.ajax({async: false, type: 'POST', url: '<?php echo admin_url( "admin-ajax.php" );?>',
            data: data,  dataType: 'json', success: function(data) { $(btn).replaceWith(data.html); }
         });
        event.preventDefault();
      });
<?php } 

if($_REQUEST['action'] == 'wishlist') {
?>
   $('a.del-wishlistlink').click(function(event) {
      var btn = this;
      var data = { action :'delete_wishlist_action', postid: $(btn).attr('data-post-item'), userid: <?php echo $user_ID; ?>,
          nonce : '<?php echo wp_create_nonce( 'imwb_zonpress_delete_wishlist' );?>'
      };
         
      $.ajax({ async: false, type: 'POST', url: '<?php echo admin_url( 'admin-ajax.php' );?>', data: data, dataType: 'json',
         success: function(data) { $(btn).parents('li').fadeOut('slow', function() {$(this).remove(); });}
      });
      event.preventDefault();
   });
<?php } ?>
   });
</script>
<?php
$pmColors = new CSS_Color(imwb_zonpress_get_option('menubgcol'));
$sbColors = new CSS_Color(imwb_zonpress_get_option('sidebarbgcol'));
?>
<style>
<?php if (imwb_zonpress_get_option('headerbgcol') != '#') { ?>
.header-wrapper  {background-color: <?php echo imwb_zonpress_get_option('headerbgcol'); ?>; }
<?php } ?>
.carousel-thumbs, .content_sidebar {background-color: <?php echo imwb_zonpress_get_option('postbgcol'); ?>; }
#mainCarousel { background-color: <?php echo imwb_zonpress_get_option('fpbgcol'); ?>; border: 1px solid <?php echo imwb_zonpress_get_option('fpbdrcol'); ?>}
#mainCarousel .carousel-inner > .item > .content .title a, #mainCarousel .carousel-inner > .item > .content .stats a, .wishlistlink, .wishlistlink:hover, .the-post h1.title {color: <?php echo imwb_zonpress_get_option('fptitlecol'); ?>;}
#mainCarousel .carousel-inner > .item > .content .title a:hover, #mainCarousel .carousel-inner > .item > .content .stats a:hover {color: <?php echo imwb_zonpress_get_option('fptitlehvrcol'); ?>;}
#mainCarousel .carousel-inner > .item > .content .description, #mainCarousel .carousel-inner > .item > .content .stats { color: <?php echo imwb_zonpress_get_option('fpdesccol'); ?>;}
.price {color: <?php echo imwb_zonpress_get_option('fppricecol'); ?>;}
<?php if (imwb_zonpress_get_option('sidebarbgcol') != '#') { ?>
.content_sidebar li,#footer .widget-area .widget_popularProducts  {background-color: #<?php echo $sbColors->bg[0]; ?>;}
.content_sidebar ul ul li a:hover, #widgets_404 ul ul li a:hover{background-color:  #<?php echo $sbColors->bg['-2']; ?>;}
<?php } ?>
#footer-wrapper  { background-color: <?php echo imwb_zonpress_get_option('footerbgcol'); ?>; }
#footer .widget-area ul ul li a {color: <?php echo imwb_zonpress_get_option('footertxtlinkcol'); ?>;}
#footer .widget-area ul ul li a:hover {color: <?php echo imwb_zonpress_get_option('footertxtlinkhvrcol'); ?>;}
#footer .widget-area .tagcloud a  {color: <?php echo imwb_zonpress_get_option('footertxtcol'); ?>;}

<?php if(imwb_zonpress_get_option('hidemenu') == 'N')   { ?>
#page-navigation {background-color: #<?php echo $pmColors->bg[0]; ?>; border-bottom: 1px solid #<?php echo $pmColors->bg['-2'] ?>; border-top: 1px solid #<?php echo $pmColors->bg['-2'] ?>;}
#page-navigation ul ul.children li { border-bottom: 1px solid #<?php echo $pmColors->bg['-2'] ?>; border-left: 1px solid #<?php echo $pmColors->bg['-2'] ?>; border-right: 1px solid #<?php echo $pmColors->bg['-2'] ?>;}
#page-navigation ul ul.children li:first-child {border-top: 1px solid #<?php echo $pmColors->bg['-2'] ?>; }
#page-navigation ul ul.children {background-color: #<?php echo $pmColors->bg[0]; ?>; }
#page-navigation ul li:hover > a { color: #<?php echo $pmColors->fg['-2']; ?>; }                  
#page-navigation ul li a { color: <?php echo imwb_zonpress_get_option('menutxtcol'); ?>;}
#site-navigation ul li a { color: <?php echo imwb_zonpress_get_option('sitemenutxtcol'); ?>;}
 <?php } else { ?>
#page-navigation ul { padding-bottom: 5px; }
 <?php } ?>
#page-navigation ul li.current-cat a{ color: <?php echo imwb_zonpress_get_option('menuseltxtcol'); ?>;}
<?php if(imwb_zonpress_get_option('posthidemenu') == 'N')   { ?>
.post-navigation {background-color:  <?php echo imwb_zonpress_get_option('postmenubgcol'); ?>;}
#post-navigation ul li a { color: <?php echo imwb_zonpress_get_option('postmenutxtcol'); ?>;}
#post-navigation ul li.current a { color: <?php echo imwb_zonpress_get_option('postmenuseltxtcol'); ?>;}
 <?php } ?>

.widget-title { background-color: <?php echo imwb_zonpress_get_option('widgettitlebgcol'); ?>; color: <?php echo imwb_zonpress_get_option('widgettitletxtcol'); ?>;}

#footer .widget-title {background-color: <?php echo imwb_zonpress_get_option('footerbgcol'); ?>; color: <?php echo imwb_zonpress_get_option('footertxtcol'); ?>;}
.actions .btn-success { color: <?php echo imwb_zonpress_get_option('postprdbtntxtcol'); ?>; background-color: <?php echo imwb_zonpress_get_option('postprdbtnbgcol'); ?>;}
.actions .btn-success:hover,.btn-success:focus,.btn-success:active,.btn-success.active,.btn-success.disabled,.btn-success[disabled] {color: <?php echo imwb_zonpress_get_option('postprdbtntxtcol'); ?>; background-color: <?php echo imwb_zonpress_get_option('postprdbtnbghvrcol'); ?>;}
.posts-wrapper {background-color: <?php echo imwb_zonpress_get_option('postbgcol'); ?>;}
.post .title a,.post .title a:visited {  color: <?php echo imwb_zonpress_get_option('posttitlecol'); ?>;}
.post .title a:hover { color: <?php echo imwb_zonpress_get_option('posttitlehvrcol'); ?>; }
.post .description, .price-info {color: <?php echo imwb_zonpress_get_option('postdesccol'); ?>;}
.the-post .content {color: <?php echo imwb_zonpress_get_option('postdesccol'); ?>;}
.the-post .stats {color: <?php echo imwb_zonpress_get_option('postdesccol'); ?>;}

<?php	
   $header_image = get_header_image();
   $text_color   = get_header_textcolor();

   if ( ! empty( $header_image ) ) {	?>
		.site-header {
			background: url(<?php echo esc_url($header_image); ?>);
			background-repeat:no-repeat;
			background-size:contain;
			background-position:center;
		}
<?php } 
		// Has the text been hidden?
	if ( ! display_header_text() ) { ?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px 1px 1px 1px); /* IE7 */
			clip: rect(1px, 1px, 1px, 1px);
		}
<?php } ?>
		.site-title,
		.site-description {
			text-align:<?php echo get_theme_mod( 'zp_header_text_align', 'center' );?>;
         <?php if ( $text_color != get_theme_support( 'custom-header', 'default-text-color' ) ) { ?>
			color: #<?php echo esc_attr( $text_color ); ?>;
			<?php }?>
		}
</style>
<?php if(imwb_zonpress_get_option('headerscripts') != '') 
   echo imwb_zonpress_get_option('headerscripts');
?>
</head>
<body <?php body_class(); ?>>
<?php if(is_single() && (imwb_zonpress_get_option('commenttype') == '1' || imwb_zonpress_get_option('commenttype') == '2')) { ?>
<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_GB/all.js#xfbml=1&appId=<?php echo imwb_zonpress_get_option('fbappid');?>";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
</script>
<?php } ?>
<div class="container-fluid header-wrapper">
 <div class="row-fluid">
  <div class="span12">
    <header class="site-header" role="banner">    	 
      <nav id="site-navigation">
      <ul>
<?php if(is_user_logged_in()) { 
   global $current_user, $user_identity;
   get_currentuserinfo();    
?> 
   <li><a href="<?php bloginfo( 'url' );?>?action=wishlist" ><?php echo imwb_zonpress_get_option('wishlisttext');?></a></li> 
   <li><a href="<?php bloginfo( 'url' );?>?action=profile"><?php _e("My Profile", "imwb_zonpress");?></a></li>
   <li class="last"><a href="<?php echo wp_logout_url('index.php');?>"><?php _e("Sign Out", "imwb_zonpress");?></a></li>

<?php } else { ?>  
   <li><a class="smcf-register" href="<?php bloginfo( 'url' );?>/wp-login.php?action=register" target="_blank"><?php _e("Create Account", "imwb_zonpress");?></a></li> 
   <li class="last"><a class="smcf-login" href="<?php bloginfo( 'url' );?>/wp-login.php"><?php _e("Sign In", "imwb_zonpress");?></a></li>
<?php } ?>
      </ul>
      </nav>
      <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
      	<hgroup>
      		<h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
      		<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
      	</hgroup>
      </a> 
   </header>
  </div> 
  </div>
  <div class="row-fluid">
   <div class="span12">
      <nav id="page-navigation">
      <ul>
      <?php if(imwb_zonpress_get_option('hidemenu') == 'N')   { ?>
       
       <?php if(imwb_zonpress_get_option('mrsmenu') == 'N')   { ?>
          <li class="cat-item<?php echo (is_home() && imwb_zonpress_list_order() == 'mrs') ? ' current-cat' : '';?>">
             <a title="<?php echo imwb_zonpress_get_option('mrsmenutitle');?>" href="<?php bloginfo( 'url' );?>?so=mrs"><?php echo imwb_zonpress_get_option('mrsmenutxt');?></a>
          </li>
       <?php } 
          $currentcategory = "";
          if (is_single() || is_category()) {
             $cat = get_the_category();
             $catId = $cat[0]->cat_ID;
             $currentcategory = '&current_category='.$catId;
          }
          $exclude = imwb_zonpress_get_option('excludecats');
          $mmInclude = imwb_zonpress_get_option('includecats');
     
          if(!empty($mmInclude)) {
             wp_list_categories('depth=0&orderby=name&use_desc_for_title=1&hide_empty=0&title_li='.$currentcategory.'&include='.$mmInclude);
          }    
          if(imwb_zonpress_get_option('othercatmenu') == 'N')   { ?>
             <li class="cat-item drop-down">
                <a title="<?php echo imwb_zonpress_get_option('othercatmenutxt');?>" href="/"><?php echo imwb_zonpress_get_option('othercatmenutxt');?><span></span></a>
             <ul class="children">
          <?php 
             if(!empty($exclude) && !empty($mmInclude))
                $exclude .= ','.$mmInclude;
             else if(empty($exclude) && !empty($mmInclude))
                $exclude = $mmInclude;
               
             wp_list_categories('depth=0&orderby=name&use_desc_for_title=1&hide_empty=0&title_li='.$currentcategory.'&exclude='.$exclude);
             
          ?></ul></li> 
          <?php
          }
         ?>
      
   <?php } ?>
      </ul>
      </nav>
   </div>
  </div>
</div>