<?php 
global $current_user, $user_identity;
if(!is_user_logged_in()) {
   wp_redirect( home_url() ); 
   exit;   
}

$errors = Array();

if($_REQUEST['submit'] != '') {
         
   if(trim($_REQUEST['firstName']) == '')
      $errors[] = __("Please enter a first name", "imwb_zonpress");
      
   if(trim($_REQUEST['lastName']) == '')
      $errors[] = __("Please enter a last name", "imwb_zonpress");   
    
   if(trim($_REQUEST['nickName']) == '')
      $errors[] = __("You must provide a nickname", "imwb_zonpress");
      
   if(trim($_REQUEST['displayName']) == '')
      $errors[] = __("Please enter a display name", "imwb_zonpress");         
      
   if(trim($_REQUEST['email']) == '')
      $errors[] = __("Please enter a email address", "imwb_zonpress");       
      
   if(trim($_REQUEST['password']) != '') {
      $password = trim($_REQUEST['password']);
      $password1= trim($_REQUEST['password1']);
      
      if($password != $password1)
        $errors[] = __("Password mismatch. Please enter the same password twice", "imwb_zonpress");
   }
       
   if(empty($errors)) {
      
      $userData = array ( 'ID' => $current_user->ID, 
                         'first_name' => trim($_REQUEST['firstName']),
                         'last_name' => trim($_REQUEST['lastName']),
                         'nickname' => trim($_REQUEST['nickName']),
                         'display_name' => trim($_REQUEST['displayName']),
                         'user_email' => trim($_REQUEST['email']));
      if($password != '')
         $userData['user_pass'] = $password;
         
      wp_update_user($userData);           
      
//      if($password != '') {
//         wp_redirect( wp_logout_url('index.php'));
//      else    
//         wp_redirect( bloginfo( 'url' )."?action=profile" );
//         exit;  
   }
   
}

$current_user = wp_get_current_user();

get_header();  

?>
<div class="container-fluid posts-wrapper">
 <div class="row-fluid">

<div class="span8 offset2"> 
	<header class="archive-header">
		<h1 class="archive-title"><?php _e("My Profile", "imwb_zonpress");?></h1>
	</header>
	<?php if(!empty($errors)) { ?>
	<div class="alert">
	<strong>Please Fix the following errors!</strong><br>
	<?php 
	   foreach ($errors as $error) 
	         echo $error.'<br>';
   ?>
	</div>
	<?php } ?>
	<form class="form-horizontal" method="post" action="">
		<div class="control-group">
		   <label class="control-label"><?php _e('Username', 'imwb_zonpress'); ?></label>
		   <div class="controls">
		     <input type="text" id="userName" name="userName" readonly value="<?php echo $current_user->user_login;?>">
		   </div>
      </div>
      <div class="control-group">
         <label class="control-label" for="firstName"><?php _e('First Name', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="text" id="firstName" name="firstName" value="<?php echo $current_user->first_name;?>" placeholder="<?php _e('First Name', 'imwb_zonpress'); ?>">
         </div>
      </div>
      <div class="control-group">
         <label class="control-label" for="lastName"><?php _e('Last Name', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="text" id="lastName" name="lastName" value="<?php echo $current_user->last_name;?>" placeholder="<?php _e('Last Name', 'imwb_zonpress'); ?>">
         </div>
      </div>
      <div class="control-group">
         <label class="control-label" for="nickName"><?php _e('Nickname', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="text" id="nickName" name="nickName" value="<?php echo $current_user->nickname;?>" placeholder="<?php _e('Required', 'imwb_zonpress'); ?>">
         </div>
      </div>
      <div class="control-group">
         <label class="control-label" for="displayName"><?php _e('Display Name', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="text" id="displayName" name="displayName" value="<?php echo $current_user->display_name;?>" placeholder="<?php _e('Required', 'imwb_zonpress'); ?>">
         </div>
      </div>   
      <div class="control-group">
         <label class="control-label" for="email"><?php _e('Email', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="text" id="email" name="email" value="<?php echo $current_user->user_email;?>" placeholder="<?php _e('Required', 'imwb_zonpress'); ?>">
         </div>
      </div> 
      <div class="control-group">
         <label class="control-label" for="password"><?php _e('New Password', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="password" id="password" name="password" value="">
         </div>
      </div>  
      <div class="control-group">
         <label class="control-label" for="password1"><?php _e('Retype Password', 'imwb_zonpress'); ?></label>
         <div class="controls">
            <input class="input-xlarge" type="password" id="password1" name="password1" value="">
         </div>
      </div>     
			<input name="submit" type="submit" class="btn" value="<?php _e( 'Update', 'imwb_zonpress' ); ?>" />
	</form>
	
		
</div>

</div>
</div>
<?php get_footer(); 
?>