jQuery(document).ready(function($) {

   $('input[type=button]').click(function() {
     var prod_keyword = $.trim($('input[name="imwb_zonpress_theme_products[keyword]"]').val());
     if(prod_keyword == '') {
        $('span.error.keyword').html('Please Enter a Product Keyword');
        return;
     }
     $('span.error.keyword').html('');
     
     var checked = $('input[name="imwb_zonpress_theme_options[networks][]"]').is(':checked');   
     if(!checked) {
        $('span.error.networks').html('Please select an Affiliate Network to search against');
        return;
     }
     
     var selNetworks = Array();
     $('input[name="imwb_zonpress_theme_options[networks][]"]').is(function() {
        if($(this).is(':checked'))
           selNetworks.push($(this).val());
     });
        	 
     $('span.error.networks').html('');
     $('.product-searching').show();
     $('.product-results').hide(); $('p.submit').hide();
     
     if(this.id == "btnSearchProducts") {
       var amzPage = 1;
       var cjPage = 1;
       var ebayPage = 1;
     } else {
        var amzPage = $('input[name="amzpage"]').val() || 1;
        var cjPage = $('input[name="cjpage"]').val() || 1;
        var ebayPage = $('input[name="ebaypage"]').val() || 0;
     }
       
     var data = { action :'search_for_products', nonce : IMWB_ZP_Search_Products.nonce, keyword: prod_keyword, numPosts: $('select[name="imwb_zonpress_theme_products[retunred]"]').val(), networks: selNetworks, amzpage: amzPage, cjpage: cjPage, ebaypage: ebayPage, amzIndex: $('select[name="imwb_zonpress_theme_products[searchindex]"]').val() };
     $.ajax({async: false, type: 'POST', url: IMWB_ZP_Search_Products.admin_url, data: data,  dataType: 'json', 
             success: function(data) { 
                $('.product-searching').hide();
                if(data.results.length > 0) {
                  $('.product-results').html(data.results);
                if(data.errors.length > 0) 
                     $('.product-results').prepend(data.errors);
                  $('p.submit').show();
                }    
                else if(data.errors.length > 0) {
                   $('.product-results').html(data.errors);
                }
       
                $('.product-results').show();
             },
             error: function(jqXHR, textStatus, errorThrown) {
                $('.product-searching').hide();
                $('.product-results').html(textStatus+": "+errorThrown);
                $('.product-results').show();
                $('p.submit').hide();
             }
     });
   });
   
   $('.product-results').on('click', '#cb-select-all-products', function(e) {
      var thisChecked = $(this).prop('checked'),
      	toggle = e.shiftKey;

      $(this).closest( 'table' ).children( 'tbody' ).filter(':visible').children('tr').find(':checkbox').prop('checked', function() {
      			if ( $(this).is(':hidden') )
      				return false;
      			if ( toggle )
      				return $(this).prop( 'checked' );
      			else if (thisChecked)
      				return true;
      			return false;
      		});
      
   });
   
	// check all checkboxes
	 $('.product-results').on('click', '.cb-select-product', function(e) {
      // toggle "check all" checkboxes
      var unchecked = $(this).closest('tbody').find(':checkbox').filter(':visible').not(':checked');
      $('#cb-select-all-products').prop('checked', function() {
      	return ( 0 == unchecked.length );
      });

		return true;
	});
	
	$('#submit-draft').on('click', function(e) { $('input[name="submit"]').val('draft'); });
	$('#submit-live').on('click', function(e) { $('input[name="submit"]').val('publish'); });
	
	$('#import-products').submit(function(e) {
	
   	 var checked = $('.product-results tbody').find(':checkbox').filter(':visible').is(':checked');
   	 
   	 if(!checked) {
   	    alert('You Have Not Selected any Products to Import');
   	    return false;
   	 }	 
   	 if($('#category').val() == null) {
   	    alert("Please select the categories to use");
   	    return false;
   	 }
   	 
   	 return true;
	});
	
	$('input[name="imwb_zonpress_theme_options[networks][]"]').on('click', function(e) {
	   if($(this).val() == 'A') {
   	   if($(this).is(':checked'))
   	      $('#amzSearchIndex').show();
   	   else
     	      $('#amzSearchIndex').hide();
	   }
	});
	
});