<?php 
	function imwb_zonpress_comment( $comment, $args, $depth ) {
	
   	$GLOBALS['comment'] = $comment; 
   	
		if ( 'div' == $args['style'] ) {
			$tag = 'div';
			$add_below = 'comment';
		} else {
			$tag = 'li';
			$add_below = 'div-comment';
		}
?>
		<<?php echo $tag; ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?> id="comment-<?php comment_ID(); ?>">
		<?php if ( 'div' != $args['style'] ) : ?>
		<div id="div-comment-<?php comment_ID(); ?>" class="comment-body">
		<?php endif; ?>
		<div class="comment-author vcard">
			<?php if ( 0 != $args['avatar_size'] ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
			<?php printf( __( '<cite class="fn">%s</cite> <span class="says">says:</span>' ), get_comment_author_link() ); ?>
			<?php edit_comment_link( __( '(Edit)' ), '&nbsp;&nbsp;', '' ); ?>
		</div>
		<?php if ( '0' == $comment->comment_approved ) : ?>
		<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.' ) ?></em>
		<br />
		<?php endif; ?>
<?php /* translators: 1: date, 2: time */
		if(imwb_zonpress_get_option('hideptcommenttime') == 'N') { ?>
		<div class="comment-meta commentmetadata">
				<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
<?php			printf( __( '%1$s at %2$s' ), get_comment_date(),  get_comment_time() ); ?></a>
		</div>
<?php }?>
		<?php comment_text() ?>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div>
		<?php if ( 'div' != $args['style'] ) : ?>
		</div>
		<?php endif; ?>
<?php
	}
?>
<div id="comments">
<h3>Comments</h3>
<div class="commentlist">
	<?php wp_list_comments(array('style' => 'div', 'avatar_size' => 52, 'callback' => 'imwb_zonpress_comment')); ?>
</div>

<?php if (! comments_open()) :?>
	<p class='stats'><?php _e("Comments are disabled for this post.", "imwb_zonpress"); ?></p>
<?php else: ?>
	<?php
	$commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
	
		$fields = array("comment" =>
				 "<div>"
				."	<textarea id=\"comment\" name=\"comment\" rows=\"8\" style=\"width:97%;\"></textarea>"
				."</div>"
		);
		comment_form(array(
			 "comment_notes_before"	=> ""
			,"comment_notes_after"  => ""
			,"title_reply"          => __("Write a comment", "imwb_zonpress")
			,"title_reply_to"       => __("Reply to %s", "imwb_zonpress")
			,"label_submit"         => __("Add comment", "imwb_zonpress")
			,"fields"               => array(
				'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name', 'imwb_zonpress' ) . '</label> ' . ( $req ? '<span class="required">*</span>' : '' ) .
				            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
				'email'  => '<p class="comment-form-email"><label for="email">' . __( 'Email', 'imwb_zonpress' ) . '</label> ' . ( $req ? '<span class="required">*</span>' : '' ) .
				            '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></p>'	)
			,"comment_field"		=> "<div><textarea id=\"comment\" name=\"comment\" rows=\"8\" style=\"width:97%;\"></textarea></div>"
		));

	?>
<?php endif; ?>
</div>